/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.StarfireBirdAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.StarfireBird;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarfireBirdModel<T extends StarfireBird>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation ADULT_LOCATION = new ModelLayerLocation(EternalStarlight.id("starfire_bird"), "main");
    public static final ModelLayerLocation BABY_LOCATION = new ModelLayerLocation(EternalStarlight.id("starfire_bird"), "baby");
    private final ModelPart root;

    public StarfireBirdModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(4, 14).addBox(-3.5f, -5.0f, 2.5f, 7.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.5f, -8.0f, -3.5f, 7.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(23, 21).addBox(-1.5f, -3.0f, -4.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)-0.5f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(22, 14).addBox(0.0f, -1.5f, 0.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)-2.5f, (float)-1.5f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(22, 14).mirror().addBox(-1.0f, -1.5f, 0.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.5f, (float)-2.5f, (float)-1.5f));
        body.addOrReplaceChild("feather", CubeListBuilder.create().texOffs(1, 18).mirror().addBox(0.0f, -4.0f, -0.5f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-8.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 14).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)22.0f, (float)-0.5f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 14).mirror().addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.5f, (float)22.0f, (float)-0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createBabyBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 3).addBox(-2.0f, -3.0f, 2.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -5.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 9).addBox(-1.0f, -3.0f, -3.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0f, (float)0.5f));
        body.addOrReplaceChild("feather", CubeListBuilder.create().texOffs(1, 10).mirror().addBox(0.0f, -3.0f, 0.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(6, 9).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)23.0f, (float)0.5f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(6, 9).mirror().addBox(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)23.0f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(((StarfireBird)((Object)entity)).idleAnimationState, StarfireBirdAnimation.IDLE, ageInTicks);
        this.animate(((StarfireBird)((Object)entity)).nestIdleAnimationState, StarfireBirdAnimation.IDLE_NEST, ageInTicks);
        float flapScale = ((StarfireBird)((Object)entity)).getFlapScale(Mth.frac((float)ageInTicks));
        this.animate(((StarfireBird)((Object)entity)).flapAnimationState, StarfireBirdAnimation.FLAP, ageInTicks, 4.0f, flapScale);
        this.animateWalk(StarfireBirdAnimation.WALK, limbSwing, limbSwingAmount, 2.5f, 1.0f - flapScale);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

