/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.environment;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FallingLeavesParticle
extends TextureSheetParticle {
    private float rotSpeed;
    private final float particleRandom;
    private final float spinAcceleration;
    private final boolean glow;

    public FallingLeavesParticle(ClientLevel clientLevel, double x, double y, double z, boolean glow, SpriteSet spriteSet) {
        super(clientLevel, x, y, z);
        float size;
        this.setSprite(spriteSet.get(this.random.nextInt(12), 12));
        this.rotSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -30.0 : 30.0);
        this.particleRandom = this.random.nextFloat();
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        this.glow = glow;
        this.lifetime = 300;
        this.gravity = 7.5E-4f;
        this.quadSize = size = 0.08f + 0.025f * this.random.nextFloat();
        this.setSize(size, size);
        this.friction = 1.0f;
    }

    public ParticleRenderType getRenderType() {
        return this.glow ? ParticleRenderType.PARTICLE_SHEET_LIT : ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (!this.removed) {
            float f = 300 - this.lifetime;
            float g = Math.min(f / 300.0f, 1.0f);
            double d = Math.cos(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow(g, 1.25);
            double e = Math.sin(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow(g, 1.25);
            this.xd += d * (double)0.0025f;
            this.zd += e * (double)0.0025f;
            this.yd -= (double)this.gravity;
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.rotSpeed / 20.0f;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround || this.lifetime < 299 && (this.xd == 0.0 || this.zd == 0.0)) {
                this.remove();
            }
            if (!this.removed) {
                this.xd *= (double)this.friction;
                this.yd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
        }
    }

    public static class GlowProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public GlowProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel clientLevel, double x, double y, double z, double xs, double ys, double zs) {
            return new FallingLeavesParticle(clientLevel, x, y, z, true, this.sprites);
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel clientLevel, double x, double y, double z, double xs, double ys, double zs) {
            return new FallingLeavesParticle(clientLevel, x, y, z, false, this.sprites);
        }
    }
}

