/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.client.model.entity.BallLightningModel;
import cn.leolezury.eternalstarlight.common.entity.projectile.BallLightning;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BallLightningRenderer
extends EntityRenderer<BallLightning> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/ball_lightning.png");
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    private final BallLightningModel<BallLightning> model;

    public BallLightningRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new BallLightningModel(context.bakeLayer(BallLightningModel.LAYER_LOCATION));
    }

    public void render(BallLightning entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.pushPose();
        float yRot = -Mth.rotLerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        float xRot = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()) - 90.0f;
        float bob = (float)entity.tickCount + partialTicks;
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -1.5f, 0.0f);
        this.model.prepareMobModel((Entity)entity, 0.0f, 0.0f, partialTicks);
        this.model.setupAnim(entity, 0.0f, 0.0f, bob, yRot, xRot);
        RenderType renderType = RenderType.eyes((ResourceLocation)this.getTextureLocation(entity));
        VertexConsumer vertexConsumer = ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(renderType);
        this.model.inner.visible = true;
        this.model.outer.visible = false;
        this.model.renderToBuffer(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        this.model.inner.visible = false;
        this.model.outer.visible = true;
        this.model.renderToBuffer(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)127, (int)30, (int)50, (int)50));
        poseStack.popPose();
        Entity target = entity.level().getEntity(entity.getTargetId());
        if (target != null) {
            Vec3 pos = new Vec3(Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX()), Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY()), Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ()));
            Vec3 startPos = new Vec3(Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX()), Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY()) + (double)(entity.getBbHeight() / 2.0f), Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ()));
            Vec3 destPos = new Vec3(Mth.lerp((double)partialTicks, (double)target.xo, (double)target.getX()), Mth.lerp((double)partialTicks, (double)target.yo, (double)target.getY()) + (double)(target.getBbHeight() / 2.0f), Mth.lerp((double)partialTicks, (double)target.zo, (double)target.getZ()));
            ArrayList<Vec3> segments = new ArrayList<Vec3>();
            int numSegments = Math.round((float)startPos.distanceTo(destPos) / 1.25f * (entity.getRandom().nextFloat() * 0.5f + 1.0f));
            float segmentLength = (float)(destPos.subtract(startPos).length() / (double)numSegments);
            Vec3 increment = destPos.subtract(startPos).scale(1.0 / (double)numSegments);
            segments.add(startPos);
            for (int i = 0; i < numSegments; ++i) {
                if (i == numSegments - 1) {
                    segments.add(startPos.add(increment.scale((double)(i + 1))));
                    continue;
                }
                segments.add(startPos.add(increment.scale((double)(i + 1))).add(new Vec3(entity.getRandom().nextDouble() - 0.5, entity.getRandom().nextDouble() - 0.5, entity.getRandom().nextDouble() - 0.5).normalize().scale((double)(segmentLength / 6.0f))));
            }
            segments.add(startPos);
            Vec3 camPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            vertexConsumer = ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.entityTranslucentNoDepth(TRAIL_TEXTURE));
            for (int i = 0; i < segments.size() - 1; ++i) {
                Vec3 start = (Vec3)segments.get(i);
                Vec3 end = (Vec3)segments.get(i + 1);
                Vec3 offset = end.subtract(start);
                Vec3 sight = camPos.subtract(start).scale(-1.0);
                Vec3 sideOffset = offset.cross(sight).normalize().scale(i == segments.size() - 2 ? 0.035 : 0.03);
                PoseStack.Pose pose = poseStack.last();
                vertexConsumer.addVertex(pose, start.subtract(pos).add(sideOffset).toVector3f()).setColor(0.6f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexConsumer.addVertex(pose, start.subtract(pos).add(sideOffset.scale(-1.0)).toVector3f()).setColor(0.6f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexConsumer.addVertex(pose, end.subtract(pos).add(sideOffset.scale(-1.0)).toVector3f()).setColor(0.6f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexConsumer.addVertex(pose, end.subtract(pos).add(sideOffset).toVector3f()).setColor(0.6f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
            }
        }
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(BallLightning entity) {
        return ENTITY_TEXTURE;
    }
}

