/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.projectile.EnergySpark;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnergySparkRenderer
extends EntityRenderer<EnergySpark> {
    private static final ResourceLocation TEXTURE_LOCATION = EternalStarlight.id("textures/entity/energy_spark.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE_LOCATION);

    public EnergySparkRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EnergySpark entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        float scale = Math.min(60.0f, (float)entity.getSpawnedTicks() + partialTicks) / 60.0f * 0.5f;
        poseStack.translate(0.0f, entity.getBbHeight() / 2.0f, 0.0f);
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer vertexConsumer = buffer.getBuffer(RENDER_TYPE);
        EnergySparkRenderer.vertex(vertexConsumer, pose, 0xF000F0, 0.5f * Mth.SQRT_OF_TWO * Mth.sin((float)Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin)), 0.5f * Mth.SQRT_OF_TWO * Mth.cos((float)Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin)), 0.0f, 1.0f);
        EnergySparkRenderer.vertex(vertexConsumer, pose, 0xF000F0, 0.5f * Mth.SQRT_OF_TWO * Mth.sin((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + 1.5707964f)), 0.5f * Mth.SQRT_OF_TWO * Mth.cos((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + 1.5707964f)), 1.0f, 1.0f);
        EnergySparkRenderer.vertex(vertexConsumer, pose, 0xF000F0, 0.5f * Mth.SQRT_OF_TWO * Mth.sin((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + (float)Math.PI)), 0.5f * Mth.SQRT_OF_TWO * Mth.cos((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + (float)Math.PI)), 1.0f, 0.0f);
        EnergySparkRenderer.vertex(vertexConsumer, pose, 0xF000F0, 0.5f * Mth.SQRT_OF_TWO * Mth.sin((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + 4.712389f)), 0.5f * Mth.SQRT_OF_TWO * Mth.cos((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + 4.712389f)), 0.0f, 0.0f);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int packedLight, float x, float y, float u, float v) {
        consumer.addVertex(pose, x, y, 0.0f).setColor(-1).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(EnergySpark entity) {
        return TEXTURE_LOCATION;
    }
}

