/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.entity.PermafrostSpitModel;
import cn.leolezury.eternalstarlight.common.entity.projectile.PermafrostSpit;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PermafrostSpitRenderer
extends EntityRenderer<PermafrostSpit> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/permafrost_spit.png");
    private static final ResourceLocation SMALL_TEXTURE = EternalStarlight.id("textures/entity/permafrost_spit_small.png");
    private final PermafrostSpitModel<PermafrostSpit> model;
    private final PermafrostSpitModel<PermafrostSpit> smallModel;

    public PermafrostSpitRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PermafrostSpitModel(context.bakeLayer(PermafrostSpitModel.LAYER_LOCATION));
        this.smallModel = new PermafrostSpitModel(context.bakeLayer(PermafrostSpitModel.SMALL_LAYER_LOCATION));
    }

    public void render(PermafrostSpit entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.pushPose();
        float yRot = -Mth.rotLerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        float xRot = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()) - 90.0f;
        float bob = (float)entity.tickCount + partialTicks;
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -1.5f - entity.getBbHeight() / 2.0f, 0.0f);
        PermafrostSpitModel<PermafrostSpit> spitModel = entity.isSmall() ? this.smallModel : this.model;
        spitModel.prepareMobModel((Entity)entity, 0.0f, 0.0f, partialTicks);
        spitModel.setupAnim(entity, 0.0f, 0.0f, bob, yRot, xRot);
        RenderType renderType = spitModel.renderType(this.getTextureLocation(entity));
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        spitModel.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(PermafrostSpit entity) {
        return entity.isSmall() ? SMALL_TEXTURE : ENTITY_TEXTURE;
    }
}

