/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.entity.TheGatekeeperModel;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.TheGatekeeperClothingLayer;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TheGatekeeperRenderer<T extends TheGatekeeper>
extends MobRenderer<T, TheGatekeeperModel<T>> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/the_gatekeeper.png");
    private static final ResourceLocation SLIM_ENTITY_TEXTURE = EternalStarlight.id("textures/entity/the_gatekeeper_slim.png");
    private static final int PHANTOM_AMOUNT = 5;
    private static final Map<String, GameProfile> PROFILES = new HashMap<String, GameProfile>();
    private final TheGatekeeperModel<T> normalModel = (TheGatekeeperModel)this.getModel();
    private final TheGatekeeperModel<T> slimModel;
    private boolean renderingPhantom = false;

    public TheGatekeeperRenderer(EntityRendererProvider.Context context) {
        super(context, new TheGatekeeperModel(context.bakeLayer(TheGatekeeperModel.LAYER_LOCATION), false), 0.5f);
        this.slimModel = new TheGatekeeperModel(context.bakeLayer(TheGatekeeperModel.SLIM_LAYER_LOCATION), true);
        this.addLayer((RenderLayer)new ItemInHandLayer<T, TheGatekeeperModel<T>>((RenderLayerParent)this, context.getItemInHandRenderer()){

            public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (!TheGatekeeperRenderer.this.renderingPhantom) {
                    super.render(poseStack, buffer, packedLight, livingEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        });
        this.addLayer(new TheGatekeeperClothingLayer(this, context.getModelSet()));
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        SkinManager skinManager = Minecraft.getInstance().getSkinManager();
        TheGatekeeperRenderer.getGameProfile(entity).ifPresent(p -> {
            this.model = skinManager.getInsecureSkin(p).model() == PlayerSkin.Model.SLIM ? this.slimModel : this.normalModel;
        });
        if (((ESBoss)entity).getBehaviorState() == 8) {
            ((TheGatekeeper)entity).teleportAnimationState.updateTime((float)((TheGatekeeper)entity).tickCount + partialTicks, 1.0f);
            float progress = Math.min((1.0f - Math.abs(Mth.clamp((float)((float)((TheGatekeeper)entity).teleportAnimationState.getAccumulatedTime() / 1000.0f * 20.0f), (float)0.0f, (float)60.0f) / 60.0f - 0.5f) * 2.0f) * 1.5f, 1.0f);
            float radius = progress * 0.5f;
            this.renderingPhantom = true;
            ((TheGatekeeperModel)this.getModel()).alphaFactor = 1.0f - progress;
            super.render(entity, entityYaw, partialTicks, stack, bufferSource, packedLight);
            ((TheGatekeeperModel)this.getModel()).alphaFactor /= 3.0f;
            for (int i = 0; i < 5; ++i) {
                stack.pushPose();
                float spin = progress * 1.5707964f + (float)i * ((float)Math.PI * 2) / 5.0f;
                Vector3f offset = new Vector3f(radius * Mth.sin((float)spin), radius * Mth.cos((float)spin), 0.0f);
                offset.rotate((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
                stack.translate(offset.x, offset.y, offset.z);
                super.render(entity, entityYaw, partialTicks, stack, bufferSource, packedLight);
                stack.popPose();
            }
            this.renderingPhantom = false;
            ((TheGatekeeperModel)this.getModel()).alphaFactor = 1.0f;
        } else {
            super.render(entity, entityYaw, partialTicks, stack, bufferSource, packedLight);
        }
    }

    protected void renderNameTag(T entity, Component displayName, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick) {
        if (!this.renderingPhantom) {
            super.renderNameTag(entity, displayName, poseStack, bufferSource, packedLight, partialTick);
        }
    }

    protected float getShadowRadius(T mob) {
        return ((ESBoss)mob).getBehaviorState() == 8 ? 0.0f : super.getShadowRadius(mob);
    }

    public ResourceLocation getTextureLocation(T entity) {
        PlayerSkin playerSkin;
        ResourceLocation texture = this.model == this.slimModel ? SLIM_ENTITY_TEXTURE : ENTITY_TEXTURE;
        SkinManager skinManager = Minecraft.getInstance().getSkinManager();
        Optional<GameProfile> profile = TheGatekeeperRenderer.getGameProfile(entity);
        if (profile.isPresent() && (playerSkin = (PlayerSkin)skinManager.getOrLoad(profile.get()).getNow(null)) != null && !playerSkin.texture().getPath().startsWith("textures/entity/player/")) {
            texture = playerSkin.texture();
        }
        return texture;
    }

    public static Optional<GameProfile> getGameProfile(TheGatekeeper entity) {
        if (entity.getCustomName() != null) {
            String customName = entity.getCustomName().getString();
            if (!PROFILES.containsKey(customName)) {
                SkullBlockEntity.fetchGameProfile((String)customName).thenAccept(optional -> optional.ifPresent(p -> PROFILES.put(customName, (GameProfile)p)));
            }
            if (PROFILES.containsKey(customName)) {
                return Optional.ofNullable(PROFILES.get(customName));
            }
        }
        return Optional.empty();
    }
}

