/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.projectile.ThioquartzShard;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class ThioquartzShardRenderer
extends EntityRenderer<ThioquartzShard> {
    private static final ResourceLocation TEXTURE_LOCATION = EternalStarlight.id("textures/entity/thioquartz_shard.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE_LOCATION);

    public ThioquartzShardRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ThioquartzShard entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(0.6f, 0.6f, 0.6f);
        poseStack.mulPose(new Quaternionf((Quaternionfc)this.entityRenderDispatcher.cameraOrientation()).rotateZ(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin)));
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer vertexConsumer = buffer.getBuffer(RENDER_TYPE);
        ThioquartzShardRenderer.vertex(vertexConsumer, pose, packedLight, 0.0f, 0, 0, 1);
        ThioquartzShardRenderer.vertex(vertexConsumer, pose, packedLight, 1.0f, 0, 1, 1);
        ThioquartzShardRenderer.vertex(vertexConsumer, pose, packedLight, 1.0f, 1, 1, 0);
        ThioquartzShardRenderer.vertex(vertexConsumer, pose, packedLight, 0.0f, 1, 0, 0);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v) {
        consumer.addVertex(pose, x - 0.5f, (float)y - 0.25f, 0.0f).setColor(-1).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(ThioquartzShard entity) {
        return TEXTURE_LOCATION;
    }
}

