/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.layer;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.client.model.entity.StarlightGolemModel;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarlightGolemGlowLayer<T extends StarlightGolem>
extends RenderLayer<T, StarlightGolemModel<T>> {
    private static final RenderType GLOW = RenderType.entityTranslucentEmissive((ResourceLocation)EternalStarlight.id("textures/entity/starlight_golem/starlight_golem_glow.png"));
    private static final RenderType GLOW_HALLOWEEN = RenderType.entityTranslucentEmissive((ResourceLocation)EternalStarlight.id("textures/entity/starlight_golem/starlight_golem_glow_halloween.png"));
    private final StarlightGolemModel<T> model;

    public StarlightGolemGlowLayer(RenderLayerParent<T, StarlightGolemModel<T>> parent, EntityModelSet modelSet) {
        super(parent);
        this.model = new StarlightGolemModel(modelSet.bakeLayer(StarlightGolemModel.LAYER_LOCATION));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.isInvisible()) {
            ((StarlightGolemModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer consumer = bufferSource.getBuffer(ClientHandlers.isHalloween ? GLOW_HALLOWEEN : GLOW);
            int alpha = (int)(Math.max(0.0f, Mth.cos((float)(ageInTicks * 0.1f + (float)Math.PI))) * 255.0f);
            if (((StarlightGolem)entity).deathAnimationTime > 0 || ((ESBoss)entity).getPhase() == 1 && ((StarlightGolem)entity).tickCount % 20 <= entity.getRandom().nextInt(10)) {
                alpha = 0;
            }
            this.model.renderToBuffer(poseStack, consumer, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f), FastColor.ARGB32.color((int)alpha, (int)255, (int)255, (int)255));
        }
    }
}

