/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PoisonousCloud
extends Entity
implements TraceableEntity {
    private static final String TAG_OWNER = "owner";
    private int attackCooldown;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerId;

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity owner) {
        this.ownerId = owner.getUUID();
        this.owner = owner;
    }

    public PoisonousCloud(EntityType<? extends PoisonousCloud> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        block9: {
            block8: {
                super.tick();
                if (this.tickCount > 100) {
                    this.discard();
                }
                if (this.level().isClientSide) break block8;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.owner == null && this.ownerId != null) {
                        Entity entity = serverLevel.getEntity(this.ownerId);
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity;
                            this.owner = livingEntity = (LivingEntity)entity;
                        }
                        if (this.owner == null) {
                            this.ownerId = null;
                        }
                    }
                }
                if (this.attackCooldown > 0) {
                    --this.attackCooldown;
                }
                if (this.getOwner() == null || this.attackCooldown > 0) break block9;
                boolean success = false;
                for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox())) {
                    if (!ESEntityUtil.shouldHarm((Entity)this.getOwner(), (Entity)livingEntity)) continue;
                    livingEntity.invulnerableTime = 0;
                    success = success || livingEntity.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.POISON, this, (Entity)this.getOwner()), 5.0f);
                    livingEntity.invulnerableTime = 0;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 80, 1));
                }
                if (!success) break block9;
                this.attackCooldown = 10;
                break block9;
            }
            int count = Mth.ceil((double)(Math.PI * (double)(this.getBbWidth() / 2.0f) * (double)(this.getBbWidth() / 2.0f) / 8.0));
            float bbWidth = this.getBbWidth();
            for (int i = 0; i < count; ++i) {
                float angle = this.random.nextFloat() * ((float)Math.PI * 2);
                float scale = Mth.sqrt((float)this.random.nextFloat()) * bbWidth;
                double x = this.getX() + (double)(Mth.cos((float)angle) * scale);
                double y = this.getY();
                double z = this.getZ() + (double)(Mth.sin((float)angle) * scale);
                this.level().addAlwaysVisibleParticle((ParticleOptions)ESSmokeParticleOptions.LUNAR_ATTACK, x, y, z, 0.0, 0.0, 0.0);
            }
        }
        this.setOldPosAndRot();
        this.setPos(this.position().add(this.getDeltaMovement()));
        this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.discard();
        }
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.hasUUID(TAG_OWNER)) {
            this.ownerId = tag.getUUID(TAG_OWNER);
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.owner != null) {
            tag.putUUID(TAG_OWNER, this.owner.getUUID());
        }
    }
}

