/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.projectile.AethersentMeteor;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AethersentGolem
extends AbstractGolem {
    public final AnimationState shootAnimationState = new AnimationState();
    public final AnimationState shootEndAnimationState = new AnimationState();
    public Vec3 leftMuzzlePos = Vec3.ZERO;
    public Vec3 rightMuzzlePos = Vec3.ZERO;
    private Vec3 lookPos = Vec3.ZERO;
    private int peaceTicks = 80;
    public boolean shouldAddShootParticle = false;
    public boolean shootPosTracked = true;
    public boolean useLeftHand = true;

    public AethersentGolem(EntityType<? extends AethersentGolem> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.aethersentGolem.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.aethersentGolem.armor()).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new GolemLookAtTargetGoal());
    }

    public void stopAllAnimStates() {
        this.shootAnimationState.stop();
        this.shootEndAnimationState.stop();
    }

    public void handleEntityEvent(byte b) {
        if (b == 100) {
            this.stopAllAnimStates();
            this.shootAnimationState.start(this.tickCount);
            this.shootPosTracked = false;
            this.useLeftHand = !this.useLeftHand;
        } else {
            super.handleEntityEvent(b);
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!itemStack.is(ESItems.AETHERSENT_INGOT.get())) {
            return InteractionResult.PASS;
        }
        float f = this.getHealth();
        this.heal(25.0f);
        if (this.getHealth() == f) {
            return InteractionResult.PASS;
        }
        itemStack.consume(1, (LivingEntity)player);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i <= 10; ++i) {
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.AETHERSENT, this.getX() + (double)((this.random.nextFloat() - 0.5f) * this.getBbWidth() * 2.0f), this.getY(), this.getZ() + (double)((this.random.nextFloat() - 0.5f) * this.getBbWidth() * 2.0f), 0.0, 1.0, 0.0));
            }
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    public void tick() {
        super.tick();
        if (this.peaceTicks >= 80) {
            this.lookPos = new Vec3(this.lookPos.x, this.getEyePosition().y, this.lookPos.z);
        }
        ++this.peaceTicks;
        if (!this.level().isClientSide) {
            if (this.tickCount % 20 == 0) {
                List<AethersentMeteor> meteors = this.level().getEntitiesOfClass(AethersentMeteor.class, this.getBoundingBox().inflate(75.0)).stream().filter(AethersentMeteor::isNatural).toList();
                List<LivingEntity> mobTargets = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(50.0)).stream().filter(living -> living.getType().is(ESTags.EntityTypes.AETHERSENT_GOLEM_TARGETS)).toList();
                if (!meteors.isEmpty() || !mobTargets.isEmpty()) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)100);
                    meteors.forEach(meteor -> meteor.dropAndDiscard(true));
                    mobTargets.forEach(living -> living.hurt(this.damageSources().magic(), 8.0f));
                    this.lookPos = !meteors.isEmpty() ? meteors.getFirst().position() : mobTargets.getFirst().position();
                    this.playSound(ESSoundEvents.AETHERSENT_GOLEM_SHOOT.get());
                    this.peaceTicks = 0;
                }
            }
        } else if (this.shootAnimationState.isStarted()) {
            if (this.shouldAddShootParticle) {
                if (this.useLeftHand) {
                    for (int i = 0; i < 15; ++i) {
                        Vec3 speed = new Vec3((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)).normalize().scale(0.15);
                        this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.leftMuzzlePos.x, this.leftMuzzlePos.y, this.leftMuzzlePos.z, speed.x, speed.y, speed.z);
                    }
                    this.level().addParticle((ParticleOptions)ESExplosionParticleOptions.AETHERSENT, this.leftMuzzlePos.x, this.leftMuzzlePos.y, this.leftMuzzlePos.z, 0.0, 0.0, 0.0);
                } else {
                    for (int i = 0; i < 15; ++i) {
                        Vec3 speed = new Vec3((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)).normalize().scale(0.15);
                        this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.rightMuzzlePos.x, this.rightMuzzlePos.y, this.rightMuzzlePos.z, speed.x, speed.y, speed.z);
                    }
                    this.level().addParticle((ParticleOptions)ESExplosionParticleOptions.AETHERSENT, this.rightMuzzlePos.x, this.rightMuzzlePos.y, this.rightMuzzlePos.z, 0.0, 0.0, 0.0);
                }
                this.shouldAddShootParticle = false;
            }
            if ((float)this.shootAnimationState.getAccumulatedTime() / 1000.0f * 20.0f > 60.0f) {
                this.shootAnimationState.stop();
                this.shootEndAnimationState.start(this.tickCount);
            }
        }
    }

    public boolean isPushable() {
        return false;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ESSoundEvents.AETHERSENT_GOLEM_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ESSoundEvents.AETHERSENT_GOLEM_DEATH.get();
    }

    private class GolemLookAtTargetGoal
    extends Goal {
        public GolemLookAtTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            AethersentGolem.this.getLookControl().setLookAt(AethersentGolem.this.lookPos.x, AethersentGolem.this.lookPos.y, AethersentGolem.this.lookPos.z, 360.0f, 360.0f);
        }
    }
}

