/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESCrests;
import cn.leolezury.eternalstarlight.common.data.ESPaintingVariants;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESServerBossEvent;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperCastFireballPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperComboPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperDanceFightPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperDashPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperDodgePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperMeleePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperSwingSwordPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperTeleportPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.GatekeeperTrades;
import cn.leolezury.eternalstarlight.common.entity.living.goal.GatekeeperTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.LookAtTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.npc.trade.SellItemTrade;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.handler.CommonHandlers;
import cn.leolezury.eternalstarlight.common.network.OpenGatekeeperGuiPacket;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapEncoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class TheGatekeeper
extends ESBoss
implements Npc,
Merchant {
    public static int GUI_RESPONSE_EMPTY = 0;
    public static int GUI_RESPONSE_CHALLENGE = 1;
    public static int GUI_RESPONSE_TRADE = 2;
    public static int GUI_RESPONSE_LEAVE = 3;
    private static final String TAG_OFFERS = "offers";
    private static final String TAG_GATEKEEPER_NAME = "gatekeeper_name";
    private static final String TAG_FIGHT_TARGET = "fight_target";
    private static final String TAG_FIGHT_PLAYER_ONLY = "fight_player_only";
    private static final String TAG_RESTOCK_COOLDOWN = "restock_cooldown";
    private int noTargetTime;
    public int viewBlockedTime;
    private final ESServerBossEvent bossEvent = new ESServerBossEvent(this, this.getUUID(), BossEvent.BossBarColor.WHITE, false);
    protected static final EntityDataAccessor<Float> FIXED_Y_ROT = SynchedEntityData.defineId(TheGatekeeper.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final BehaviorManager<TheGatekeeper> behaviorManager = new BehaviorManager<TheGatekeeper>(this, List.of(new GatekeeperMeleePhase(), new GatekeeperDodgePhase(), new GatekeeperDashPhase(), new GatekeeperCastFireballPhase(), new GatekeeperDanceFightPhase(), new GatekeeperSwingSwordPhase(), new GatekeeperComboPhase(), new GatekeeperTeleportPhase()));
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState meleeAnimationStateA = new AnimationState();
    public AnimationState meleeAnimationStateB = new AnimationState();
    public AnimationState meleeAnimationStateC = new AnimationState();
    public AnimationState dodgeAnimationState = new AnimationState();
    public AnimationState dashAnimationState = new AnimationState();
    public AnimationState castFireballAnimationState = new AnimationState();
    public AnimationState danceFightAnimationState = new AnimationState();
    public AnimationState swingSwordAnimationState = new AnimationState();
    public AnimationState comboAnimationState = new AnimationState();
    public AnimationState teleportAnimationState = new AnimationState();
    private String gatekeeperName = "TheGatekeeper";
    @Nullable
    private Player customer;
    @Nullable
    protected MerchantOffers offers;
    private int restockCooldown;
    @Nullable
    private ServerPlayer conversationTarget;
    @Nullable
    private String fightTarget;
    private boolean fightPlayerOnly = true;

    public TheGatekeeper(EntityType<? extends TheGatekeeper> entityType, Level level) {
        super(entityType, level);
    }

    public float getFixedYRot() {
        return ((Float)this.getEntityData().get(FIXED_Y_ROT)).floatValue();
    }

    public void setFixedYRot(float attackYRot) {
        this.getEntityData().set(FIXED_Y_ROT, (Object)Float.valueOf(attackYRot));
    }

    public void setFightPlayerOnly(boolean fightPlayerOnly) {
        this.fightPlayerOnly = fightPlayerOnly;
    }

    public void setFightTargetName(String fightTarget) {
        this.fightTarget = fightTarget;
    }

    public Optional<? extends Player> getFightTarget() {
        return this.level().players().stream().filter(p -> p.getName().getString().equals(this.fightTarget)).findFirst();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FIXED_Y_ROT, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains(TAG_OFFERS)) {
            DataResult parsed = MerchantOffers.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag.get(TAG_OFFERS));
            parsed.resultOrPartial(Util.prefix((String)"Failed to load offers: ", arg_0 -> ((Logger)EternalStarlight.LOGGER).warn(arg_0))).ifPresent(merchantOffers -> {
                this.offers = merchantOffers;
            });
        }
        this.gatekeeperName = compoundTag.getString(TAG_GATEKEEPER_NAME);
        this.fightTarget = compoundTag.getString(TAG_FIGHT_TARGET);
        this.fightPlayerOnly = compoundTag.getBoolean(TAG_FIGHT_PLAYER_ONLY);
        this.restockCooldown = compoundTag.getInt(TAG_RESTOCK_COOLDOWN);
        this.bossEvent.setId(this.getUUID());
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.addTrades();
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundTag) {
        MerchantOffers merchantOffers;
        super.addAdditionalSaveData(compoundTag);
        if (!this.level().isClientSide && !(merchantOffers = this.getOffers()).isEmpty()) {
            compoundTag.put(TAG_OFFERS, (Tag)MerchantOffers.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)merchantOffers).getOrThrow());
        }
        compoundTag.putString(TAG_GATEKEEPER_NAME, this.gatekeeperName);
        if (this.fightTarget != null) {
            compoundTag.putString(TAG_FIGHT_TARGET, this.fightTarget);
        }
        compoundTag.putBoolean(TAG_FIGHT_PLAYER_ONLY, this.fightPlayerOnly);
        compoundTag.putInt(TAG_RESTOCK_COOLDOWN, this.restockCooldown);
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        this.bossEvent.addPlayer(serverPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.bossEvent.removePlayer(serverPlayer);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 0.5, false){

            protected void checkAndPerformAttack(LivingEntity livingEntity) {
            }
        });
        this.goalSelector.addGoal(2, (Goal)new LookAtTargetGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new GatekeeperTargetGoal((PathfinderMob)this){

            @Override
            public boolean canUse() {
                return super.canUse() && TheGatekeeper.this.fightPlayerOnly && TheGatekeeper.this.isActivated();
            }
        });
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{TheGatekeeper.class}){

            public boolean canUse() {
                return super.canUse() && !TheGatekeeper.this.fightPlayerOnly && TheGatekeeper.this.isActivated();
            }
        }.setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean canUse() {
                return super.canUse() && !TheGatekeeper.this.fightPlayerOnly && TheGatekeeper.this.isActivated();
            }
        });
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl((Mob)this){

            public void clientTick() {
                if (TheGatekeeper.this.getBehaviorState() == 3) {
                    TheGatekeeper.this.setYBodyRot(TheGatekeeper.this.getFixedYRot());
                    TheGatekeeper.this.setYHeadRot(TheGatekeeper.this.getFixedYRot());
                } else {
                    super.clientTick();
                }
            }
        };
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.theGatekeeper.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.theGatekeeper.armor()).add(Attributes.ATTACK_DAMAGE, ESConfig.INSTANCE.mobsConfig.theGatekeeper.attackDamage()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.theGatekeeper.followRange()).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ARMOR_TOUGHNESS, 5.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.8);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        RandomSource randomSource = serverLevelAccessor.getRandom();
        this.populateDefaultEquipmentSlots(randomSource, difficultyInstance);
        return spawnGroupData;
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        super.populateDefaultEquipmentSlots(randomSource, difficultyInstance);
        Arrays.fill(this.handDropChances, 0.0f);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ESItems.SHATTERED_SWORD.get()));
    }

    public void stopAllAnimStates() {
        this.meleeAnimationStateA.stop();
        this.meleeAnimationStateB.stop();
        this.meleeAnimationStateC.stop();
        this.dodgeAnimationState.stop();
        this.dashAnimationState.stop();
        this.castFireballAnimationState.stop();
        this.danceFightAnimationState.stop();
        this.swingSwordAnimationState.stop();
        this.comboAnimationState.stop();
        this.teleportAnimationState.stop();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        if (accessor.equals((Object)BEHAVIOR_STATE) && this.getBehaviorState() != 0) {
            this.stopAllAnimStates();
            switch (this.getBehaviorState()) {
                case 1: {
                    switch (this.getRandom().nextInt(3)) {
                        case 0: {
                            this.meleeAnimationStateA.start(this.tickCount);
                            break;
                        }
                        case 1: {
                            this.meleeAnimationStateB.start(this.tickCount);
                            break;
                        }
                        case 2: {
                            this.meleeAnimationStateC.start(this.tickCount);
                        }
                    }
                    break;
                }
                case 2: {
                    this.dodgeAnimationState.start(this.tickCount);
                    break;
                }
                case 3: {
                    this.dashAnimationState.start(this.tickCount);
                    break;
                }
                case 4: {
                    this.castFireballAnimationState.start(this.tickCount);
                    break;
                }
                case 5: {
                    this.danceFightAnimationState.start(this.tickCount);
                    break;
                }
                case 6: {
                    this.swingSwordAnimationState.start(this.tickCount);
                    break;
                }
                case 7: {
                    this.comboAnimationState.start(this.tickCount);
                    break;
                }
                case 8: {
                    this.teleportAnimationState.start(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(accessor);
    }

    public boolean canAttack(LivingEntity livingEntity) {
        return super.canAttack(livingEntity) && this.isActivated();
    }

    public void setDeltaMovement(Vec3 vec3) {
        boolean cantMove = this.getBehaviorState() == 5 || this.getBehaviorState() == 6 || this.getBehaviorState() == 8;
        super.setDeltaMovement(cantMove ? new Vec3(0.0, vec3.y, 0.0) : vec3);
    }

    @Override
    public void initializeBoss() {
        super.initializeBoss();
        this.setActivated(false);
        this.gatekeeperName = CommonHandlers.getGatekeeperName();
    }

    @Override
    public boolean shouldPlayBossMusic() {
        return super.shouldPlayBossMusic() && this.isActivated();
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ServerPlayer serverPlayer;
        if (!this.level().isClientSide && player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).getServer() != null && this.getTradingPlayer() == null && !this.isActivated() && this.getTarget() == null && this.getFightTarget().isEmpty()) {
            AdvancementHolder killDragon = serverPlayer.getServer().getAdvancements().get(ResourceLocation.withDefaultNamespace((String)"end/kill_dragon"));
            if (killDragon != null && serverPlayer.getAdvancements().getOrStartProgress(killDragon).isDone() && !this.isPlayerPermitted(serverPlayer)) {
                this.permitPlayer(serverPlayer);
                ItemStack lootBag = this.getBossLootBag();
                ItemEntity item = player.spawnAtLocation(lootBag);
                if (item != null) {
                    item.setTarget(player.getUUID());
                    item.setGlowingTag(true);
                    item.setExtendedLifetime();
                }
            }
            this.conversationTarget = serverPlayer;
            ESPlatform.INSTANCE.sendToClient(serverPlayer, new OpenGatekeeperGuiPacket(this.getId(), this.isPlayerPermitted(serverPlayer)));
        }
        return this.isActivated() ? InteractionResult.PASS : InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    public synchronized void handleDialogueClose(int operation) {
        if (this.conversationTarget != null) {
            if (operation == GUI_RESPONSE_CHALLENGE) {
                this.fightPlayerOnly = true;
                this.setFightTargetName(this.conversationTarget.getName().getString());
                this.setTarget((LivingEntity)this.conversationTarget);
                this.setActivated(true);
            }
            if (operation == GUI_RESPONSE_TRADE && this.isPlayerPermitted(this.conversationTarget) && this.offers != null && !this.offers.isEmpty()) {
                this.setTradingPlayer((Player)this.conversationTarget);
                this.openTradingScreen((Player)this.conversationTarget, this.getDisplayName(), 1);
            }
            if (operation == GUI_RESPONSE_LEAVE) {
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    RandomSource random = serverLevel.getRandom();
                    for (int i = 0; i <= 25; ++i) {
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.DEATH, this.getX() + (double)((random.nextFloat() - 0.5f) * this.getBbWidth() * 3.0f), this.getY(), this.getZ() + (double)((random.nextFloat() - 0.5f) * this.getBbWidth() * 3.0f), 0.0, 1.0, 0.0));
                    }
                }
                this.discard();
            }
            this.conversationTarget = null;
        }
    }

    private void permitPlayer(ServerPlayer player) {
        ESCriteriaTriggers.CHALLENGED_GATEKEEPER.get().trigger(player);
        ESBookUtil.unlock(player, EternalStarlight.id("permitted_by_gatekeeper"));
    }

    private boolean isPlayerPermitted(ServerPlayer player) {
        if (player.getServer() != null) {
            boolean challenged;
            AdvancementHolder challenge = player.getServer().getAdvancements().get(EternalStarlight.id("challenge_gatekeeper"));
            boolean bl = challenged = challenge != null && player.getAdvancements().getOrStartProgress(challenge).isDone();
            if (challenged) {
                return true;
            }
        }
        return ESBookUtil.getUnlockedParts(player).contains(EternalStarlight.id("permitted_by_gatekeeper"));
    }

    public void spawnMeleeAttackParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float lookYaw = this.getYHeadRot() + 90.0f;
            float lookPitch = -this.getXRot();
            Vec3 initialEndPos = ESMathUtil.rotationToPosition(this.getEyePosition(), 1.0f, lookPitch, lookYaw);
            for (int i = 0; i < 3; ++i) {
                Vec3 endPos = initialEndPos.offsetRandom(this.getRandom(), 0.25f);
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((ParticleOptions)ESParticles.LUNAR_SLASH.get(), this.getEyePosition().x, this.getEyePosition().y, this.getEyePosition().z, endPos.x - this.getEyePosition().x, endPos.y - this.getEyePosition().y, endPos.z - this.getEyePosition().z));
            }
        }
    }

    @Override
    public void die(DamageSource source) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            super.die(source);
        } else if (!this.level().isClientSide) {
            this.getFightTarget().ifPresent(p -> {
                if (p instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)p;
                    this.permitPlayer(serverPlayer);
                    ESDataAttachments.GATEKEEPER_CHALLENGE_COUNT.setData((Entity)serverPlayer, ESDataAttachments.GATEKEEPER_CHALLENGE_COUNT.getData((Entity)serverPlayer) + 1);
                }
            });
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.dropCustomDeathLoot(serverLevel, source, true);
                for (UUID uuid : this.fightParticipants) {
                    Player player = this.level().getPlayerByUUID(uuid);
                    if (!(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!player.isAlive() || player.level().dimension() != this.level().dimension()) continue;
                    this.permitPlayer(serverPlayer);
                }
            }
            this.abortFight();
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (!(source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || source.getEntity() != null && this.getTarget() != null && this.getBehaviorState() != 8)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    private void tryTeleportBack() {
        if (this.getInitialPos().dimension() != this.level().dimension()) {
            return;
        }
        Vec3 initialPos = this.getInitialPos().pos();
        BlockPos blockPos = BlockPos.containing((Position)initialPos);
        if (initialPos.distanceTo(this.position()) > 15.0) {
            Stream<VoxelShape> shapes = StreamSupport.stream(this.level().getBlockCollisions((Entity)this, this.getBoundingBox().move(initialPos.subtract(this.position()))).spliterator(), false);
            if (shapes.allMatch(VoxelShape::isEmpty) && this.level().getBlockState(blockPos.below()).isFaceSturdy((BlockGetter)this.level(), blockPos.below(), Direction.UP)) {
                this.setPos(initialPos);
                return;
            }
            for (int i = 0; !(i >= 16 || this.teleportTowards(initialPos) && initialPos.distanceTo(this.position()) <= 15.0); ++i) {
            }
        }
    }

    private boolean teleportTowards(Vec3 target) {
        Vec3 vec3 = new Vec3(this.getX() - target.x(), this.getY(0.5) - target.y(), this.getZ() - target.z()).normalize();
        double x = this.getX() + (this.random.nextDouble() - 0.5) * 8.0 - vec3.x * 16.0;
        double y = this.getY() + (double)(this.random.nextInt(16) - 8) - vec3.y * 16.0;
        double z = this.getZ() + (this.random.nextDouble() - 0.5) * 8.0 - vec3.z * 16.0;
        return this.teleport(target, x, y, z);
    }

    private boolean teleport(Vec3 target, double x, double y, double z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)mutableBlockPos).blocksMotion()) {
            mutableBlockPos.move(Direction.DOWN);
        }
        BlockState blockState = this.level().getBlockState((BlockPos)mutableBlockPos);
        if (blockState.blocksMotion()) {
            return this.randomTeleportGatekeeper(target, x, y, z);
        }
        return false;
    }

    private boolean randomTeleportGatekeeper(Vec3 target, double x, double y, double z) {
        double oldX = this.getX();
        double oldY = this.getY();
        double oldZ = this.getZ();
        double currentY = y;
        boolean success = false;
        BlockPos blockPos = BlockPos.containing((double)x, (double)currentY, (double)z);
        Level level = this.level();
        if (level.hasChunkAt(blockPos)) {
            boolean blocksMotion = false;
            while (!blocksMotion && blockPos.getY() > level.getMinBuildHeight()) {
                BlockPos blockPos2 = blockPos.below();
                BlockState blockState = level.getBlockState(blockPos2);
                if (blockState.blocksMotion()) {
                    blocksMotion = true;
                    continue;
                }
                currentY -= 1.0;
                blockPos = blockPos2;
            }
            if (blocksMotion) {
                Vec3 vec3 = new Vec3(x, currentY, z);
                if (vec3.distanceTo(target) <= 15.0) {
                    if (ESPlatform.INSTANCE.postTeleportEvent((Entity)this, new Vec3(x, currentY, z))) {
                        this.teleportTo(x, currentY, z);
                    }
                    boolean bl = success = level.noCollision((Entity)this) && !level.containsAnyLiquid(this.getBoundingBox());
                }
            }
        }
        if (!success && ESPlatform.INSTANCE.postTeleportEvent((Entity)this, new Vec3(oldX, oldY, oldZ))) {
            this.teleportTo(oldX, oldY, oldZ);
        }
        return success;
    }

    public void aiStep() {
        super.aiStep();
        this.bossEvent.update();
        if (this.tickCount % 5 == 0 && !this.isActivated()) {
            this.bossEvent.allConvertToUnseen();
        }
        this.refreshDimensions();
        if (!this.level().isClientSide) {
            if (this.tickCount > 5 && this.isAlive() && this.isActivated() && (this.getTarget() == null || !this.getTarget().isAlive())) {
                ++this.noTargetTime;
                if (this.getFightTarget().isEmpty() || this.noTargetTime > 200) {
                    this.abortFight();
                    this.noTargetTime = 0;
                }
            }
            this.viewBlockedTime = this.getTarget() != null && !this.hasLineOfSight((Entity)this.getTarget()) ? ++this.viewBlockedTime : 0;
            if (this.restockCooldown > 0) {
                --this.restockCooldown;
            } else {
                this.restockCooldown = 12000;
                this.restockAll();
            }
            if (this.getTradingPlayer() != null && this.getTradingPlayer().distanceTo((Entity)this) > 16.0f) {
                this.setTradingPlayer(null);
            }
            this.setCustomName((Component)Component.literal((String)this.gatekeeperName));
            this.setCustomNameVisible(true);
            if (this.isLeftHanded()) {
                this.setLeftHanded(false);
            }
            if (this.isActivated() && !this.isNoAi() && this.isAlive()) {
                this.behaviorManager.tick();
            } else {
                this.setBehaviorState(0);
                this.setBehaviorTicks(0);
            }
        } else {
            this.idleAnimationState.startIfStopped(this.tickCount);
        }
    }

    public void abortFight() {
        this.setHealth(this.getMaxHealth());
        this.setFightTargetName("");
        this.setTarget(null);
        this.setActivated(false);
        this.tryTeleportBack();
        this.fightParticipants.clear();
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions dimensions = super.getDefaultDimensions(pose);
        return this.isActivated() ? dimensions : dimensions.scale(1.0f, 0.7f);
    }

    @Override
    public void dropExtraLoot(ServerPlayer player) {
        ESCrestUtil.upgradeCrest((Player)player, ESCrests.GUIDANCE_OF_STARS);
    }

    @Override
    public SoundEvent getBossMusic() {
        return ESSoundEvents.MUSIC_BOSS_GATEKEEPER.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.PLAYER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    public void setTradingPlayer(@Nullable Player player) {
        this.customer = player;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.customer;
    }

    public MerchantOffers getOffers() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.addTrades();
        }
        return this.offers;
    }

    protected void addTrades() {
        MerchantOffers merchantoffers = this.getOffers();
        this.addTrades(merchantoffers, GatekeeperTrades.TRADES, 50);
        this.addTrades(merchantoffers, new VillagerTrades.ItemListing[]{new SellItemTrade((ItemStack)Util.make(() -> {
            ItemStack stack = ESItems.STARLIT_PAINTING.get().getDefaultInstance();
            stack.set(DataComponents.ENTITY_DATA, (Object)((CustomData)CustomData.EMPTY.update((DynamicOps)this.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (MapEncoder)Painting.VARIANT_MAP_CODEC, (Object)this.level().registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getHolderOrThrow(ESPaintingVariants.GUARDIAN)).getOrThrow()).update(compoundTag -> compoundTag.putString("id", "eternal_starlight:painting")));
            return stack;
        }), new ItemStack((ItemLike)ESItems.STARLIGHT_SILVER_COIN.get(), 10), 10)}, 50);
    }

    protected void addTrades(MerchantOffers original, VillagerTrades.ItemListing[] newTrades, int maxNumbers) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.random.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ItemListing trade = newTrades[integer];
            MerchantOffer merchantoffer = trade.getOffer((Entity)this, this.random);
            if (merchantoffer == null) continue;
            original.add((Object)merchantoffer);
        }
    }

    protected void restockAll() {
        for (MerchantOffer merchantoffer : this.getOffers()) {
            merchantoffer.resetUses();
        }
    }

    public void overrideOffers(@Nullable MerchantOffers offers) {
    }

    public void notifyTrade(MerchantOffer offer) {
        offer.increaseUses();
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        if (offer.shouldRewardExp()) {
            int i = 3 + this.random.nextInt(4);
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    public void notifyTradeUpdated(ItemStack stack) {
    }

    public int getVillagerXp() {
        return 0;
    }

    public void overrideXp(int xp) {
    }

    public boolean showProgressBar() {
        return false;
    }

    public SoundEvent getNotifyTradeSound() {
        return SoundEvents.PLAYER_LEVELUP;
    }

    public boolean isClientSide() {
        return this.level().isClientSide;
    }
}

