/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.projectile.ThrownBoomerang;
import cn.leolezury.eternalstarlight.common.entity.projectile.ThrownEnergyBoomerang;
import cn.leolezury.eternalstarlight.common.item.combat.BoomerangItem;
import cn.leolezury.eternalstarlight.common.item.combat.ESItemTiers;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnergyBoomerangItem
extends BoomerangItem {
    public EnergyBoomerangItem(Item.Properties properties) {
        super(ESItemTiers.GOLEM_STEEL, properties.component(DataComponents.TOOL, (Object)EnergyBoomerangItem.createToolProperties()));
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 7.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public ThrownBoomerang createBoomerang(Level level, @Nullable LivingEntity owner, double x, double y, double z, ItemStack pickupItemStack) {
        return new ThrownEnergyBoomerang(level, owner, x, y, z, pickupItemStack);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        ThrownEnergyBoomerang boomerang = new ThrownEnergyBoomerang(level, null, pos.x(), pos.y(), pos.z(), stack.copyWithCount(1));
        boomerang.pickup = AbstractArrow.Pickup.ALLOWED;
        return boomerang;
    }
}

