/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.projectile.BallLightning;
import cn.leolezury.eternalstarlight.common.item.combat.GreatswordItem;
import cn.leolezury.eternalstarlight.common.item.interfaces.Swingable;
import cn.leolezury.eternalstarlight.common.util.SpecialItemCooldown;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GolemSteelGreatswordItem
extends GreatswordItem
implements Swingable {
    public GolemSteelGreatswordItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    private void performSpecialAttack(LivingEntity entity) {
        Level level = entity.level();
        if (!level.isClientSide && !SpecialItemCooldown.isOnCooldown((Entity)entity, (Item)this)) {
            Vec3 shootPos = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            BallLightning lastBall = null;
            for (int i = -1; i <= 1; ++i) {
                BallLightning lightning = new BallLightning(level, shootPos.x, shootPos.y, shootPos.z);
                lightning.setOwner((Entity)entity);
                lightning.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot() + (float)(i * 15), 0.0f, 0.8f, 2.0f);
                if (lastBall != null) {
                    lightning.setTarget((Entity)lastBall);
                }
                level.addFreshEntity((Entity)lightning);
                lastBall = lightning;
            }
            SpecialItemCooldown.setCooldown((Entity)entity, (Item)this, 100);
        }
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.postHurtEnemy(stack, target, attacker);
        this.performSpecialAttack(attacker);
    }

    @Override
    public void swing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        this.performSpecialAttack(entity);
    }
}

