/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class AbysslatePatchFeature
extends Feature<Configuration> {
    public AbysslatePatchFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    if (!ESMathUtil.isPointInOrOnEllipsoid(x, y, z, 3 + random.nextInt(3) - 1, 3 + random.nextInt(3) - 1, 3 + random.nextInt(3) - 1)) continue;
                    placePos.setWithOffset((Vec3i)pos, x, y, z);
                    if (!level.getBlockState((BlockPos)placePos).is(config.stone()) || !level.getBlockState(placePos.above()).isAir() && level.getBlockState(placePos.above()).getFluidState().isEmpty() || random.nextInt(8) != 0) continue;
                    if (random.nextBoolean()) {
                        this.setBlock((LevelWriter)level, (BlockPos)placePos, config.magma().getState(random, (BlockPos)placePos));
                        if (random.nextInt(5) != 0) continue;
                        this.setBlock((LevelWriter)level, placePos.above(), (BlockState)ESBlocks.ABYSSAL_FIRE.get().defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                        continue;
                    }
                    this.setBlock((LevelWriter)level, (BlockPos)placePos, config.geyser().getState(random, (BlockPos)placePos));
                }
            }
        }
        return true;
    }

    public record Configuration(Block stone, BlockStateProvider magma, BlockStateProvider geyser) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("stone").forGetter(Configuration::stone), (App)BlockStateProvider.CODEC.fieldOf("magma").forGetter(Configuration::magma), (App)BlockStateProvider.CODEC.fieldOf("geyser").forGetter(Configuration::geyser)).apply((Applicative)instance, Configuration::new));
    }
}

