/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome;

import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.registry.ESDataTransformerTypes;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldGenProvider;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformerType;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.NoiseDataTransformer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class AddRiversTransformer
extends NoiseDataTransformer {
    public static final MapCodec<AddRiversTransformer> CODEC = RiverWithOffset.CODEC.listOf().fieldOf("rivers").xmap(AddRiversTransformer::new, transformer -> transformer.rivers);
    private final List<RiverWithOffset> rivers;
    private final IntArrayList idList = new IntArrayList();

    public AddRiversTransformer(List<RiverWithOffset> rivers) {
        this.rivers = rivers;
    }

    @Override
    public int transform(WorldGenProvider provider, Random random, int original, int worldX, int worldZ, PerlinSimplexNoise noise) {
        if (this.idList.isEmpty()) {
            for (RiverWithOffset river : this.rivers) {
                this.idList.add(provider.getBiomeDataId((BiomeData)river.river().value()));
            }
        }
        if (provider.getBiomeDataById(original).canHaveRivers()) {
            for (int i = 0; i < this.rivers.size(); ++i) {
                RiverWithOffset river;
                river = this.rivers.get(i);
                double noiseVal = noise.getValue((double)(worldX + river.offset()) * 0.0025, (double)(worldZ + river.offset()) * 0.0025, false) * 0.5 + noise.getValue((double)(worldX + river.offset()) * 0.0075, (double)(worldZ + river.offset()) * 0.0075, true) * 0.25 + noise.getValue((double)(worldX + river.offset()) * 0.025, (double)(worldZ + river.offset()) * 0.025, true) * 0.025;
                if (!(noiseVal > (double)(-river.size())) || !(noiseVal < (double)river.size())) continue;
                return this.idList.getInt(i);
            }
        }
        return original;
    }

    @Override
    public DataTransformerType<?> type() {
        return ESDataTransformerTypes.ADD_RIVERS.get();
    }

    public record RiverWithOffset(Holder<BiomeData> river, float size, int offset) {
        public static final Codec<RiverWithOffset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryFileCodec.create(ESRegistries.BIOME_DATA, BiomeData.CODEC).fieldOf("river").forGetter(RiverWithOffset::river), (App)Codec.FLOAT.fieldOf("size").forGetter(RiverWithOffset::size), (App)Codec.INT.fieldOf("offset").forGetter(RiverWithOffset::offset)).apply((Applicative)instance, RiverWithOffset::new));
    }
}

