/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.util.TextHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import net.swedz.extended_industrialization.EIArmorMaterials;
import net.swedz.extended_industrialization.EIBlocks;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.EIConfig;
import net.swedz.extended_industrialization.EICreativeTabs;
import net.swedz.extended_industrialization.EIDataMaps;
import net.swedz.extended_industrialization.EIEntities;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EILocalizedListeners;
import net.swedz.extended_industrialization.EILootModifiers;
import net.swedz.extended_industrialization.EIRecipeTypes;
import net.swedz.extended_industrialization.EISounds;
import net.swedz.extended_industrialization.EIText;
import net.swedz.extended_industrialization.EITooltips;
import net.swedz.extended_industrialization.component.RainbowDataComponent;
import net.swedz.extended_industrialization.datagen.DatagenDelegator;
import net.swedz.extended_industrialization.datagen.client.provider.LanguageDatagenProvider;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.LargeElectricFurnaceBlockEntity;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.teslatower.TeslaTowerBlockEntity;
import net.swedz.extended_industrialization.machines.guicomponent.EIModularSlotPanelSlots;
import net.swedz.extended_industrialization.material.EIMaterialRegistry;
import net.swedz.extended_industrialization.network.EIPackets;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.api.tuple.Pair;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMI;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MIParser;
import net.swedz.tesseract.neoforge.config.ConfigManager;
import net.swedz.tesseract.neoforge.lang.LangInstance;
import net.swedz.tesseract.neoforge.lang.LangManager;
import net.swedz.tesseract.neoforge.registry.RegisteredObjectHolder;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="extended_industrialization")
public final class EI {
    public static final String ID = "extended_industrialization";
    public static final String NAME = "Extended Industrialization";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Extended Industrialization");
    private static EIConfig CONFIG;
    private static EIText TEXT;

    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)name);
    }

    public EI(IEventBus bus, ModContainer container) {
        EI.setupText();
        EI.setupConfig(bus, container);
        EILocalizedListeners.INSTANCE.init();
        TesseractMI.init((String)ID);
        EIComponents.init(bus);
        EIArmorMaterials.init(bus);
        EIItems.init(bus);
        EIBlocks.init(bus);
        EIFluids.init(bus);
        EIEntities.init(bus);
        EILootModifiers.init(bus);
        EIMaterialRegistry.init();
        EICreativeTabs.init(bus);
        EIRecipeTypes.init(bus);
        EISounds.init(bus);
        EIModularSlotPanelSlots.init();
        bus.register((Object)new DatagenDelegator());
        bus.addListener(FMLCommonSetupEvent.class, event -> {
            EIItems.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            EIBlocks.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            EIFluids.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
        });
        bus.addListener(RegisterCapabilitiesEvent.class, event -> CapabilitiesListeners.triggerAll((String)ID, (RegisterCapabilitiesEvent)event));
        bus.addListener(RegisterPayloadHandlersEvent.class, EIPackets::init);
        bus.addListener(RegisterDataMapTypesEvent.class, EIDataMaps::init);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, DataMapsUpdatedEvent.class, event -> event.ifRegistry(Registries.BLOCK, registry -> LargeElectricFurnaceBlockEntity.initTiers()));
        TeslaTowerBlockEntity.registerTieredShapes();
    }

    public static EIConfig config() {
        Assert.notNull((Object)CONFIG, (String)"Config not yet loaded");
        return CONFIG;
    }

    private static void setupConfig(IEventBus bus, ModContainer container) {
        ConfigManager manager = new ConfigManager().includeDefaultValueComments();
        manager.codecs().register(EIConfig.CableTierDamages.class, EIConfig.CableTierDamages.CODEC);
        CONFIG = (EIConfig)manager.build(EIConfig.class).register(container, ModConfig.Type.STARTUP).load().listenToLoad(bus).config();
    }

    public static EIText text() {
        Assert.notNull((Object)TEXT, (String)"Text not yet loaded");
        return TEXT;
    }

    private static void setupText() {
        LangInstance instance = new LangManager(ID).builtinColorStyles().style("tooltip", () -> MITooltips.DEFAULT_STYLE).style("tooltip_subtext", () -> MITooltips.DEFAULT_STYLE.withItalic(Boolean.valueOf(true))).style("highlighted", () -> MITooltips.HIGHLIGHT_STYLE).style("rainbow", () -> Style.EMPTY.withColor(RainbowDataComponent.getCurrentRainbowColor())).builtinParsers().parser("keybind", String.class, () -> EITooltips.KEYBIND_PARSER).parser("percentage", Float.TYPE, () -> value -> Parser.FLOAT_PERCENTAGE.parse(value, (Object)0)).parser("eu_per_tick", Long.TYPE, () -> value -> {
            TextHelper.Amount amount = TextHelper.getAmountGeneric((Number)value);
            return MIText.EuT.text(new Object[]{amount.digit(), amount.unit()});
        }).parser("eu", Long.TYPE, () -> value -> {
            TextHelper.Amount amount = TextHelper.getAmountGeneric((Number)value);
            return MIText.Eu.text(new Object[]{amount.digit(), amount.unit()});
        }).parser("damage", Float.TYPE, () -> EITooltips.DAMAGE_PARSER).parser("ticks_to_minutes", Long.TYPE, () -> EITooltips.TICKS_TO_MINUTES_PARSER).parser("activated", Boolean.TYPE, () -> EITooltips.ACTIVATED_BOOLEAN_PARSER).parser("short", CableTier.class, () -> MIParser.CABLE_TIER_SHORT).parser(EuCostTransformer.class, () -> MIParser.EU_COST_TRANSFORMER_PARSER).parser(ElectricToolItem.Mode.class, () -> mode -> mode.text().name()).parser(EIText.EnchantmentWithLevelField.class, () -> value -> Parser.ENCHANTMENT_AND_LEVEL.parse((Object)value.registry(), (Object)new Pair(value.enchantment(), (Object)value.level()))).parser(EIText.EnchantmentField.class, () -> value -> Parser.ENCHANTMENT.parse((Object)value.registry(), value.enchantment())).parser("enchantment_level", Integer.TYPE, () -> Parser.ENCHANTMENT_LEVEL).build(EIText.class).load();
        LanguageDatagenProvider.include(instance);
        TEXT = (EIText)instance.lang();
    }
}

