/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.swedz.extended_industrialization.item.ElectricToolItem;
import org.apache.commons.lang3.mutable.MutableObject;

@EventBusSubscriber(modid="extended_industrialization", value={Dist.CLIENT})
public final class ElectricToolHighlight {
    @SubscribeEvent
    private static void onBlockHighlight(RenderHighlightEvent.Block event) {
        ElectricToolItem tool;
        Optional<ElectricToolItem.Area> optionalArea;
        LocalPlayer player = Minecraft.getInstance().player;
        Level level = player.level();
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof ElectricToolItem && (optionalArea = (tool = (ElectricToolItem)item).getArea((BlockGetter)level, (Player)player, stack, true)).isPresent()) {
            ElectricToolItem.Area area = optionalArea.get();
            BlockPos center = area.center();
            MutableObject fullShape = new MutableObject((Object)Shapes.empty());
            ElectricToolItem.forEachMineableBlock((BlockGetter)level, area, (LivingEntity)player, (pos, state) -> {
                float destroyProgress = state.getDestroyProgress((Player)player, (BlockGetter)level, pos);
                if (!((double)destroyProgress <= 1.0E-9)) {
                    VoxelShape blockShape = state.getShape((BlockGetter)level, pos, CollisionContext.of((Entity)event.getCamera().getEntity()));
                    blockShape = blockShape.move((double)(pos.getX() - center.getX()), (double)(pos.getY() - center.getY()), (double)(pos.getZ() - center.getZ()));
                    fullShape.setValue((Object)Shapes.joinUnoptimized((VoxelShape)((VoxelShape)fullShape.getValue()), (VoxelShape)blockShape, (BooleanOp)BooleanOp.OR));
                }
            });
            if (fullShape.getValue() != Shapes.empty()) {
                LevelRenderer.renderShape((PoseStack)event.getPoseStack(), (VertexConsumer)event.getMultiBufferSource().getBuffer(RenderType.lines()), (VoxelShape)((VoxelShape)fullShape.getValue()), (double)((double)center.getX() - event.getCamera().getPosition().x()), (double)((double)center.getY() - event.getCamera().getPosition().y()), (double)((double)center.getZ() - event.getCamera().getPosition().z()), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                event.setCanceled(true);
            }
        }
    }
}

