/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.ber.tesla.arc;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.swedz.extended_industrialization.client.ber.tesla.arc.TeslaArcPoint;
import net.swedz.extended_industrialization.client.ber.tesla.arc.TeslaArcRenderPoint;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public final class TeslaArcRenderer {
    public static void renderArc(PoseStack matrices, VertexConsumer consumer, List<TeslaArcPoint> points, Function<Float, Float> widthFunction, float r, float g, float b, float a) {
        int i;
        Matrix4f pose = matrices.last().pose();
        if (points.size() < 2) {
            return;
        }
        ArrayList positions = Lists.newArrayList();
        for (TeslaArcPoint point : points) {
            Vector4f matrixPosition = point.matrixPosition();
            matrixPosition.mul((Matrix4fc)pose);
            positions.add(matrixPosition);
        }
        int count = points.size() - 1;
        float increment = 1.0f / (float)count;
        TeslaArcRenderPoint[] renderPoints = new TeslaArcRenderPoint[points.size()];
        for (i = 1; i < count; ++i) {
            float width = widthFunction.apply(Float.valueOf(increment * (float)i)).floatValue();
            Vector4f previous = (Vector4f)positions.get(i - 1);
            Vector4f current = (Vector4f)positions.get(i);
            Vector4f next = (Vector4f)positions.get(i + 1);
            renderPoints[i] = new TeslaArcRenderPoint(current, TeslaArcRenderer.perpendicularPoints(previous, next, width));
        }
        renderPoints[0] = new TeslaArcRenderPoint((Vector4f)positions.get(0), TeslaArcRenderer.perpendicularPoints((Vector4f)positions.get(0), (Vector4f)positions.get(1), widthFunction.apply(Float.valueOf(0.0f)).floatValue()));
        renderPoints[count] = new TeslaArcRenderPoint((Vector4f)positions.get(count), TeslaArcRenderer.perpendicularPoints((Vector4f)positions.get(count - 1), (Vector4f)positions.get(count), widthFunction.apply(Float.valueOf(1.0f)).floatValue()));
        renderPoints[0].renderStart(consumer, 0.0f, 0.0f, 1.0f, Mth.lerp((float)increment, (float)0.0f, (float)1.0f), r, g, b, a);
        for (i = 1; i < count; ++i) {
            float current = Mth.lerp((float)((float)i * increment), (float)0.0f, (float)1.0f);
            renderPoints[i].renderMid(consumer, 0.0f, current, 1.0f, current, r, g, b, a);
        }
        renderPoints[count].renderEnd(consumer, 0.0f, Mth.lerp((float)((float)count * increment), (float)0.0f, (float)1.0f), 1.0f, 1.0f, r, g, b, a);
    }

    private static Vec2 perpendicularPoints(Vector4f start, Vector4f end, float width) {
        float x = -start.x();
        float y = -start.y();
        if (Math.abs(start.z()) > 0.0f) {
            float ratio = end.z() / start.z();
            x = end.x() + x * ratio;
            y = end.y() + y * ratio;
        } else if (Math.abs(end.z()) <= 0.0f) {
            x += end.x();
            y += end.y();
        }
        if (start.z() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / TeslaArcRenderer.distance(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vec2(-y, x);
    }

    private static float distSqr(float ... a) {
        float d = 0.0f;
        for (float f : a) {
            d += f * f;
        }
        return d;
    }

    private static float distance(float ... a) {
        return Mth.sqrt((float)TeslaArcRenderer.distSqr(a));
    }
}

