/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public interface MachineOverlaysJson {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();

    public Material[] toSpriteIds();

    public int[] getOutputSpriteIndexes();

    public static <O extends MachineOverlaysJson> O parse(Class<O> clazz, JsonObject json, MachineOverlaysJson defaultOverlay) {
        MachineOverlaysJson overlays = (MachineOverlaysJson)GSON.fromJson((JsonElement)json, clazz);
        if (defaultOverlay != null) {
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    if (field.get(overlays) != null) continue;
                    field.set(overlays, field.get(defaultOverlay));
                }
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Failed to copy fields from default overlay", ex);
            }
        }
        return (O)overlays;
    }

    default public Material select(ResourceLocation ... candidates) {
        for (ResourceLocation id : candidates) {
            if (id == null) continue;
            return new Material(InventoryMenu.BLOCK_ATLAS, id);
        }
        return null;
    }
}

