/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.compat.continuity;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import net.minecraft.client.resources.model.BakedModel;
import net.neoforged.fml.ModList;

public final class ContinuityModelUnwrapper {
    private static final MethodHandle UNWRAP_BAKED_MODEL;

    public static BakedModel unwrap(BakedModel model) {
        if (UNWRAP_BAKED_MODEL != null) {
            try {
                model = UNWRAP_BAKED_MODEL.invokeExact(model);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to unwrap model", ex);
            }
        }
        return model;
    }

    static {
        MethodHandle unwrapBakedModel = null;
        if (ModList.get().isLoaded("fabric_renderer_api_v1")) {
            try {
                Class<?> wrapperBakedModel = Class.forName("net.fabricmc.fabric.api.renderer.v1.model.WrapperBakedModel");
                Method unwrap = wrapperBakedModel.getMethod("unwrap", BakedModel.class);
                unwrapBakedModel = MethodHandles.lookup().unreflect(unwrap);
            }
            catch (ReflectiveOperationException ex) {
                LogUtils.getLogger().error("Failed to reflect WrapperBakedModel.unwrap method", (Throwable)ex);
            }
        }
        UNWRAP_BAKED_MODEL = unwrapBakedModel;
    }
}

