/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.recipes;

import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialRegistry;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EIMachines;
import net.swedz.extended_industrialization.datagen.server.provider.recipes.RecipesServerDatagenProvider;
import net.swedz.tesseract.neoforge.compat.mi.recipe.MIMachineRecipeBuilder;

public final class AlloySmelterRecipesServerDatagenProvider
extends RecipesServerDatagenProvider {
    public AlloySmelterRecipesServerDatagenProvider(GatherDataEvent event) {
        super(event);
    }

    private static Ingredient combine(Ingredient ... ingredients) {
        ArrayList values = Lists.newArrayList();
        for (Ingredient ingredient : ingredients) {
            values.addAll(List.of(ingredient.getValues()));
        }
        return Ingredient.fromValues(values.stream());
    }

    private static void addAlloySmelterRecipes(Material componentA, int amountA, Material componentB, int amountB, Material result, int amountResult, RecipeOutput output) {
        AlloySmelterRecipesServerDatagenProvider.addMaterialMachineRecipe(result, "ingot", EIMachines.RecipeTypes.ALLOY_SMELTER, 4, 200, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(AlloySmelterRecipesServerDatagenProvider.combine(componentA.getPart((PartKeyProvider)MIParts.DUST).getTaggedIngredient(), componentA.getPart((PartKeyProvider)MIParts.INGOT).getTaggedIngredient()), amountA, 1.0f)).addItemInput(AlloySmelterRecipesServerDatagenProvider.combine(componentB.getPart((PartKeyProvider)MIParts.DUST).getTaggedIngredient(), componentB.getPart((PartKeyProvider)MIParts.INGOT).getTaggedIngredient()), amountB, 1.0f)).addItemOutput((ItemLike)result.getPart((PartKeyProvider)MIParts.INGOT), amountResult), output);
        AlloySmelterRecipesServerDatagenProvider.addMaterialMachineRecipe(result, "nugget", EIMachines.RecipeTypes.ALLOY_SMELTER, 4, 200, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(AlloySmelterRecipesServerDatagenProvider.combine(componentA.getPart((PartKeyProvider)MIParts.TINY_DUST).getTaggedIngredient(), componentA.getPart((PartKeyProvider)MIParts.NUGGET).getTaggedIngredient()), amountA * 9, 1.0f)).addItemInput(AlloySmelterRecipesServerDatagenProvider.combine(componentB.getPart((PartKeyProvider)MIParts.TINY_DUST).getTaggedIngredient(), componentB.getPart((PartKeyProvider)MIParts.NUGGET).getTaggedIngredient()), amountB * 9, 1.0f)).addItemOutput((ItemLike)result.getPart((PartKeyProvider)MIParts.INGOT), amountResult), output);
        AlloySmelterRecipesServerDatagenProvider.addMaterialMachineRecipe(result, "block", EIMachines.RecipeTypes.ALLOY_SMELTER, 4, 1800, r -> ((MIMachineRecipeBuilder)((MIMachineRecipeBuilder)r.addItemInput(componentA.getPart((PartKeyProvider)MIParts.BLOCK).getTaggedIngredient(), amountA, 1.0f)).addItemInput(componentB.getPart((PartKeyProvider)MIParts.BLOCK).getTaggedIngredient(), amountB, 1.0f)).addItemOutput((ItemLike)result.getPart((PartKeyProvider)MIParts.BLOCK), amountResult), output);
    }

    protected void buildRecipes(RecipeOutput output) {
        AlloySmelterRecipesServerDatagenProvider.addAlloySmelterRecipes(MaterialRegistry.getMaterial((String)"tin"), 1, MaterialRegistry.getMaterial((String)"copper"), 3, MaterialRegistry.getMaterial((String)"bronze"), 4, output);
        AlloySmelterRecipesServerDatagenProvider.addAlloySmelterRecipes(MaterialRegistry.getMaterial((String)"lead"), 1, MaterialRegistry.getMaterial((String)"antimony"), 1, MaterialRegistry.getMaterial((String)"battery_alloy"), 2, output);
        AlloySmelterRecipesServerDatagenProvider.addAlloySmelterRecipes(MaterialRegistry.getMaterial((String)"copper"), 1, MaterialRegistry.getMaterial((String)"nickel"), 1, MaterialRegistry.getMaterial((String)"cupronickel"), 2, output);
        AlloySmelterRecipesServerDatagenProvider.addAlloySmelterRecipes(MaterialRegistry.getMaterial((String)"iron"), 2, MaterialRegistry.getMaterial((String)"nickel"), 1, MaterialRegistry.getMaterial((String)"invar"), 3, output);
        AlloySmelterRecipesServerDatagenProvider.addAlloySmelterRecipes(MaterialRegistry.getMaterial((String)"gold"), 1, MaterialRegistry.getMaterial((String)"silver"), 1, MaterialRegistry.getMaterial((String)"electrum"), 2, output);
    }
}

