/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.machineconfig;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.util.Simulation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigApplicable;
import net.swedz.extended_industrialization.mixin.mi.accessor.ActiveShapeComponentAccessor;

record MachineConfigActiveShape(int activeShape) implements MachineConfigApplicable<MachineBlockEntity>
{
    public static final Codec<MachineConfigActiveShape> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("active_shape").forGetter(MachineConfigActiveShape::activeShape)).apply((Applicative)instance, MachineConfigActiveShape::new));

    public static Optional<MachineConfigActiveShape> from(MachineBlockEntity machine) {
        return (Optional)machine.components.mapOrDefault(ActiveShapeComponent.class, component -> Optional.of(new MachineConfigActiveShape(component.getActiveShapeIndex())), Optional.empty());
    }

    @Override
    public boolean matches(MachineBlockEntity target) {
        return (Boolean)target.components.mapOrDefault(ActiveShapeComponent.class, component -> this.activeShape < component.shapeTemplates.length, (Object)false);
    }

    @Override
    public boolean apply(Player player, MachineBlockEntity target, Simulation simulation) {
        if (!this.matches(target)) {
            return false;
        }
        if (simulation.isActing()) {
            ((ActiveShapeComponentAccessor)target.components.getOrThrow(ActiveShapeComponent.class)).setActiveShape(this.activeShape);
        }
        return true;
    }
}

