/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.CableTierHolder;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerComponent;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGui;
import net.swedz.tesseract.neoforge.compat.mi.helper.transfer.MIEnergyTransferCache;
import net.swedz.tesseract.neoforge.helper.transfer.FluidTransferCache;
import net.swedz.tesseract.neoforge.helper.transfer.ItemTransferCache;

public final class MachineChainerMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
CableTierHolder {
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final CasingComponent casing;
    private final ChainerComponent chainer = new ChainerComponent(this, EI.config().machineChainerMaxConnections(), () -> this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this));
    private final ItemTransferCache transferItem;
    private final FluidTransferCache transferFluid;
    private final MIEnergyTransferCache transferEnergy;
    private int tick;
    private int lastRebuildTick = -1;
    private int rebuildsThisTick = 0;
    private boolean needsRebuild;

    public MachineChainerMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(EI.id("machine_chainer"), false).backgroundHeight(175).build(), new OrientationComponent.Params(true, true, true, true));
        this.casing = new CasingComponent((from, to) -> this.chainer.invalidate());
        this.transferItem = new ItemTransferCache(this.chainer::itemHandler);
        this.transferFluid = new FluidTransferCache(this.chainer::fluidHandler);
        this.transferEnergy = new MIEnergyTransferCache(this.chainer::extractableEnergyHandler);
        this.registerGuiComponent(new GuiComponentServer[]{new SlotPanel((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withCasing(this.casing)});
        this.registerGuiComponent(new GuiComponentServer[]{new AutoExtract(this.orientation)});
        this.registerGuiComponent(new GuiComponentServer[]{new ModularMultiblockGui(11, 50, content -> {
            ChainerLinks links = this.chainer.links();
            if (!links.hasConnections() && links.failPosition().isPresent()) {
                content.add((Component)EI.text().machineChainerProblemAt(links.failPosition().get()), 0xFF0000);
            } else {
                content.add((Component)EI.text().machineChainerConnectedMachines(links.count(), links.maxConnections()));
            }
        })});
        this.registerComponents(new MachineComponent[]{this.chainer, this.redstoneControl, this.casing});
    }

    public ChainerComponent getChainerComponent() {
        return this.chainer;
    }

    public void buildLinks() {
        ++this.rebuildsThisTick;
        if (this.tick == this.lastRebuildTick) {
            this.needsRebuild = true;
            return;
        }
        this.needsRebuild = false;
        if (!this.level.isClientSide()) {
            this.chainer.unregisterListeners();
            this.chainer.invalidate();
            this.chainer.registerListeners();
        }
        this.invalidateCapabilities();
        this.setChanged();
        if (!this.level.isClientSide()) {
            this.sync();
        }
        this.lastRebuildTick = this.tick;
    }

    public CableTier getCableTier() {
        return this.casing.getCableTier();
    }

    public long getMaxTransfer() {
        int multiplier = EI.config().machineChainerMaxTransferMultiplier();
        return multiplier == 0 ? Long.MAX_VALUE : this.getCableTier().getMaxTransfer() * (long)multiplier;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.casing.getCasing());
        this.orientation.writeModelData(data);
        return data;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide()) {
            this.needsRebuild = true;
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide()) {
            this.chainer.unregisterListeners();
            this.chainer.clear();
        }
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (++this.tick % 200 == 0) {
            this.needsRebuild = true;
        }
        if (this.needsRebuild) {
            this.buildLinks();
        }
        if (this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this)) {
            if (this.orientation.extractItems) {
                this.transferItem.autoExtract(this.level, this.worldPosition, this.orientation.outputDirection);
            }
            if (this.orientation.extractFluids) {
                this.transferFluid.autoExtract(this.level, this.worldPosition, this.orientation.outputDirection);
            }
            if (this.transferEnergy.autoExtract(this.level, this.worldPosition, this.orientation.outputDirection, this.getCableTier(), this.getMaxTransfer())) {
                this.setChanged();
            }
        }
        if (this.rebuildsThisTick >= 10) {
            EI.LOGGER.warn("Prevented Machine Chainer in dimension '{}' at ({}) from rebuilding links {} times in the same tick!", new Object[]{this.level.dimension().location(), this.worldPosition.toShortString(), this.rebuildsThisTick});
        }
        this.rebuildsThisTick = 0;
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.casing.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    public static void registerCapabilities(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, bet, (be, direction) -> ((MachineChainerMachineBlockEntity)((Object)((Object)be))).getChainerComponent().itemHandler());
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, bet, (be, direction) -> ((MachineChainerMachineBlockEntity)((Object)((Object)be))).getChainerComponent().fluidHandler());
            event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> {
                MachineChainerMachineBlockEntity machine = (MachineChainerMachineBlockEntity)((Object)((Object)be));
                ChainerComponent chainer = machine.getChainerComponent();
                return machine.orientation.outputDirection == direction ? chainer.extractableEnergyHandler() : chainer.insertableEnergyHandler();
            });
        });
    }
}

