/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.multiblock;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.HatchTypes;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.datamap.LargeElectricFurnaceTier;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMI;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformer;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.multiplied.EuCostTransformers;
import net.swedz.tesseract.neoforge.compat.mi.helper.CommonGuiComponents;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractElectricMultipliedCraftingMultiblockBlockEntity;

public final class LargeElectricFurnaceBlockEntity
extends AbstractElectricMultipliedCraftingMultiblockBlockEntity {
    private static List<Tier> TIERS = List.of();
    private static Map<ResourceLocation, Tier> TIERS_BY_COIL = Collections.unmodifiableMap(Maps.newHashMap());
    private static ShapeTemplate[] SHAPE_TEMPLATES = new ShapeTemplate[0];

    public LargeElectricFurnaceBlockEntity(BEP bep) {
        super(bep, EI.id("large_electric_furnace"), SHAPE_TEMPLATES, MachineTier.LV);
        List<Component> tierComponents = TIERS.stream().map(Tier::getDisplayName).toList();
        this.registerGuiComponent(new GuiComponentServer[]{CommonGuiComponents.rangedShapeSelection((MultiblockMachineBlockEntity)this, (ActiveShapeComponent)this.activeShape, tierComponents, (boolean)true)});
    }

    public Tier getActiveTier() {
        return TIERS.get(this.activeShape.getActiveShapeIndex());
    }

    public MachineRecipeType getRecipeType() {
        return MIMachineRecipeTypes.FURNACE;
    }

    public int getMaxMultiplier() {
        return this.getActiveTier().batchSize();
    }

    public EuCostTransformer getEuCostTransformer() {
        return EuCostTransformers.percentage(() -> Float.valueOf(this.getActiveTier().euCostMultiplier()));
    }

    public List<Component> getTooltips() {
        return List.of(TesseractMI.text().machineBatcherRecipe(true, this.getRecipeType()), EI.text().machineBatcherCoils());
    }

    public static List<Tier> getTiers() {
        return TIERS;
    }

    public static Map<ResourceLocation, Tier> getTiersByCoil() {
        return TIERS_BY_COIL;
    }

    public static void initTiers() {
        ArrayList tiers = Lists.newArrayList();
        LargeElectricFurnaceTier.getAll().forEach((block, tier) -> tiers.add(new Tier(block.location(), tier.batchSize(), tier.euCostMultiplier())));
        tiers.sort(Comparator.comparingInt(Tier::batchSize));
        TIERS = Collections.unmodifiableList(tiers);
        TIERS_BY_COIL = TIERS.stream().collect(Collectors.toMap(Tier::blockId, Function.identity()));
        SHAPE_TEMPLATES = new ShapeTemplate[TIERS.size()];
        SimpleMember heatproofMachineCasing = SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"heatproof_machine_casing"))));
        HatchFlags hatches = new HatchFlags.Builder().with(new HatchType[]{HatchTypes.ITEM_INPUT, HatchTypes.ITEM_OUTPUT, HatchTypes.ENERGY_INPUT}).build();
        for (int i = 0; i < TIERS.size(); ++i) {
            ShapeTemplate shape;
            Tier tier2 = TIERS.get(i);
            SimpleMember coil = SimpleMember.forBlockId((ResourceLocation)tier2.blockId());
            LargeElectricFurnaceBlockEntity.SHAPE_TEMPLATES[i] = shape = new ShapeTemplate.Builder(MachineCasings.HEATPROOF).add3by3(0, heatproofMachineCasing, false, hatches).add3by3(1, coil, true, HatchFlags.NO_HATCH).add3by3(2, heatproofMachineCasing, false, hatches).build();
        }
        LargeElectricFurnaceBlockEntity.registerReiShapes();
    }

    private static void registerReiShapes() {
        ReiMachineRecipes.multiblockShapes.removeIf(e -> e.machine().equals((Object)EI.id("large_electric_furnace")));
        int index = 0;
        for (ShapeTemplate shapeTemplate : SHAPE_TEMPLATES) {
            ReiMachineRecipes.registerMultiblockShape((ResourceLocation)EI.id("large_electric_furnace"), (ShapeTemplate)shapeTemplate, (String)("" + index));
            ++index;
        }
    }

    public record Tier(ResourceLocation blockId, int batchSize, float euCostMultiplier) {
        public String getTranslationKey() {
            return "lef_tier.%s.%s.%s".formatted("extended_industrialization", this.blockId.getNamespace(), this.blockId.getPath());
        }

        public Component getDisplayName() {
            return Component.translatable((String)this.getTranslationKey());
        }
    }
}

