/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer.task.task;

import java.util.List;
import net.minecraft.world.level.block.state.BlockState;
import net.swedz.extended_industrialization.machines.component.farmer.FarmerComponent;
import net.swedz.extended_industrialization.machines.component.farmer.PlantableConfigurableItemStack;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerTile;
import net.swedz.extended_industrialization.machines.component.farmer.planting.FarmerPlantable;
import net.swedz.extended_industrialization.machines.component.farmer.planting.PlantableBehaviorHolder;
import net.swedz.extended_industrialization.machines.component.farmer.planting.PlantingContext;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTask;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskType;

public final class PlantingFarmerTask
extends FarmerTask {
    private final PlantableBehaviorHolder plantingHandlers;

    public PlantingFarmerTask(FarmerComponent component) {
        super(FarmerTaskType.PLANTING, component);
        this.plantingHandlers = component.getPlantableBehaviorHolder();
    }

    @Override
    protected boolean run() {
        List<PlantableConfigurableItemStack> plantables = this.plantableStacks.getItems();
        plantables.removeIf(plantable -> !plantable.isPlantable() || !this.plantingMode.includeEmptyStacks() && plantable.getStack().isEmpty());
        if (plantables.isEmpty()) {
            return false;
        }
        for (FarmerTile tile : this.blockMap) {
            int index = this.plantingMode.index(tile, plantables);
            if (index == -1) {
                for (PlantableConfigurableItemStack plantable2 : plantables) {
                    if (!this.tryPlant(plantable2, tile)) continue;
                    return true;
                }
                continue;
            }
            PlantableConfigurableItemStack plantable3 = plantables.get(index);
            if (!this.tryPlant(plantable3, tile)) continue;
            return true;
        }
        return this.operations.didOperate();
    }

    private boolean tryPlant(PlantableConfigurableItemStack plantable, FarmerTile tile) {
        if (plantable.getStack().isEmpty()) {
            return false;
        }
        BlockState state = tile.crop().state(this.level);
        if (state == state.getFluidState().createLegacyBlock()) {
            PlantingContext plantingContext = new PlantingContext(this.level, tile, plantable.getStack().toStack());
            FarmerPlantable farmerPlantable = plantable.asPlantable();
            if (farmerPlantable.canPlant(plantingContext)) {
                plantable.getStack().decrement(1L);
                farmerPlantable.plant(plantingContext);
                return this.operations.operate();
            }
        }
        return false;
    }
}

