/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.recipe;

import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.ProxyableMachineRecipeType;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.tesseract.neoforge.compat.mi.recipe.MIMachineRecipeBuilder;

public final class BreweryMachineRecipeType
extends ProxyableMachineRecipeType {
    private static String id(ResourceLocation location) {
        return "%s/%s".formatted(location.getNamespace(), location.getPath());
    }

    private static String id(Item item) {
        return BreweryMachineRecipeType.id(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    private static String idItem(Holder<Item> item) {
        return BreweryMachineRecipeType.id((Item)item.value());
    }

    private static String id(ItemStack stack) {
        return BreweryMachineRecipeType.id(stack.getItem());
    }

    private static String id(Ingredient ingredient) {
        return BreweryMachineRecipeType.id(ingredient.getItems()[0]);
    }

    private static String idPotion(Holder<Potion> potion) {
        return BreweryMachineRecipeType.id(potion.getKey().location());
    }

    public BreweryMachineRecipeType(ResourceLocation id) {
        super(id);
    }

    private RecipeHolder<MachineRecipe> generate(ResourceLocation id, Ingredient inputIngredient, Ingredient reagentIngredient, ItemStack outputStack) {
        MIMachineRecipeBuilder recipe = new MIMachineRecipeBuilder((MachineRecipeType)this, 4, 100);
        recipe.addItemInput(inputIngredient, 4, 1.0f);
        recipe.addItemInput(reagentIngredient, 1, 1.0f);
        recipe.addFluidInput((FluidLike)EIFluids.BLAZING_ESSENCE, 1);
        recipe.addItemOutput(ItemVariant.of((ItemStack)outputStack), 4, 1.0f);
        return new RecipeHolder(id, (Recipe)((MachineRecipe)recipe.convert()));
    }

    private RecipeHolder<MachineRecipe> generate(ResourceLocation id, ItemStack inputStack, Ingredient reagentIngredient, ItemStack outputStack) {
        return this.generate(id, DataComponentIngredient.of((boolean)false, (ItemStack)inputStack), reagentIngredient, outputStack);
    }

    private RecipeHolder<MachineRecipe> generateMix(ItemStack stack, PotionBrewing.Mix<Potion> mix) {
        ItemStack inputStack = stack.copy();
        inputStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(mix.from()));
        Ingredient reagentIngredient = mix.ingredient();
        ItemStack outputStack = stack.copy();
        outputStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(mix.to()));
        ResourceLocation id = EI.id("/brewery/generated/mix/%s/%s/%s/%s".formatted(BreweryMachineRecipeType.id(stack), BreweryMachineRecipeType.idPotion((Holder<Potion>)mix.from()), BreweryMachineRecipeType.id(reagentIngredient), BreweryMachineRecipeType.idPotion((Holder<Potion>)mix.to())));
        return this.generate(id, inputStack, reagentIngredient, outputStack);
    }

    private List<RecipeHolder<MachineRecipe>> buildMixes(Level level, PotionBrewing potionBrewing) {
        ArrayList recipes = Lists.newArrayList();
        for (Ingredient allowedContainer : potionBrewing.containers) {
            for (ItemStack stack : allowedContainer.getItems()) {
                for (PotionBrewing.Mix mix : potionBrewing.potionMixes) {
                    if (mix.ingredient().getItems().length <= 0) continue;
                    recipes.add(this.generateMix(stack, (PotionBrewing.Mix<Potion>)mix));
                }
            }
        }
        return recipes;
    }

    private RecipeHolder<MachineRecipe> generateContainer(PotionBrewing.Mix<Item> mix, Holder<Potion> potion) {
        ItemStack inputStack = new ItemStack((ItemLike)mix.from().value());
        inputStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
        Ingredient reagentIngredient = mix.ingredient();
        ItemStack outputStack = new ItemStack((ItemLike)mix.to().value());
        outputStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
        ResourceLocation id = EI.id("/brewery/generated/container/%s/%s/%s/%s".formatted(BreweryMachineRecipeType.id(((ResourceKey)potion.unwrapKey().orElseThrow()).location()), BreweryMachineRecipeType.idItem((Holder<Item>)mix.from()), BreweryMachineRecipeType.id(reagentIngredient), BreweryMachineRecipeType.idItem((Holder<Item>)mix.to())));
        return this.generate(id, inputStack, reagentIngredient, outputStack);
    }

    private List<RecipeHolder<MachineRecipe>> buildContainers(Level level, PotionBrewing potionBrewing) {
        ArrayList recipes = Lists.newArrayList();
        for (PotionBrewing.Mix mix : potionBrewing.containerMixes) {
            if (mix.ingredient().getItems().length <= 0) continue;
            Consumer<Holder> recipeGen = entry -> {
                Potion potion = (Potion)entry.value();
                if (potion == null || !potionBrewing.isBrewablePotion(entry)) {
                    return;
                }
                recipes.add(this.generateContainer((PotionBrewing.Mix<Item>)mix, (Holder<Potion>)entry));
            };
            if (mix.from().value() instanceof PotionItem) {
                BuiltInRegistries.POTION.holders().forEach(recipeGen);
                continue;
            }
            recipeGen.accept(BuiltInRegistries.POTION.wrapAsHolder((Object)((Potion)Potions.AWKWARD.value())));
        }
        return recipes;
    }

    private RecipeHolder<MachineRecipe> generateModded(ItemStack inputStack, Ingredient reagentIngredient, ItemStack outputStack) {
        ResourceLocation id = EI.id("/brewery/generated/modded_improper/%s/%s/%s".formatted(BreweryMachineRecipeType.id(inputStack), BreweryMachineRecipeType.id(reagentIngredient), BreweryMachineRecipeType.id(outputStack)));
        if (inputStack.has(DataComponents.POTION_CONTENTS) && outputStack.has(DataComponents.POTION_CONTENTS)) {
            Optional inputPotion = ((PotionContents)inputStack.get(DataComponents.POTION_CONTENTS)).potion();
            Optional outputPotion = ((PotionContents)outputStack.get(DataComponents.POTION_CONTENTS)).potion();
            if (inputPotion.isPresent() && outputPotion.isPresent()) {
                id = EI.id("/brewery/generated/modded/%s/%s/%s".formatted(BreweryMachineRecipeType.idPotion((Holder<Potion>)((Holder)inputPotion.get())), BreweryMachineRecipeType.id(reagentIngredient), BreweryMachineRecipeType.idPotion((Holder<Potion>)((Holder)outputPotion.get()))));
            }
        }
        return this.generate(id, inputStack, reagentIngredient, outputStack);
    }

    private List<RecipeHolder<MachineRecipe>> generateModded(BrewingRecipe brewingRecipe) {
        ArrayList recipes = Lists.newArrayList();
        for (ItemStack inputStack : brewingRecipe.getInput().getItems()) {
            Ingredient reagentIngredient = brewingRecipe.getIngredient();
            ItemStack outputStack = brewingRecipe.getOutput(inputStack, reagentIngredient.getItems()[0]);
            recipes.add(this.generateModded(inputStack, reagentIngredient, outputStack));
        }
        return recipes;
    }

    private List<RecipeHolder<MachineRecipe>> buildModded(Level level, PotionBrewing potionBrewing) {
        ArrayList recipes = Lists.newArrayList();
        for (IBrewingRecipe entry : potionBrewing.getRecipes()) {
            if (!(entry instanceof BrewingRecipe)) continue;
            BrewingRecipe brewingRecipe = (BrewingRecipe)entry;
            recipes.addAll(this.generateModded(brewingRecipe));
        }
        return recipes;
    }

    protected void fillRecipeList(Level level, List<RecipeHolder<MachineRecipe>> recipeList) {
        recipeList.addAll(this.getManagerRecipes(level));
        recipeList.addAll(this.buildMixes(level, level.potionBrewing()));
        recipeList.addAll(this.buildContainers(level, level.potionBrewing()));
        recipeList.addAll(this.buildModded(level, level.potionBrewing()));
    }
}

