/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.item.teslalinkable.SelectedTeslaNetwork;
import net.swedz.extended_industrialization.item.teslalinkable.TeslaHandheldReceiverItem;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaReceiverHolder;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.PlayerTeslaReceiver;
import net.swedz.extended_industrialization.machines.component.tesla.network.receiver.TeslaReceiver;
import net.swedz.extended_industrialization.proxy.modslot.EIModSlotProxy;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
@Implements(value={@Interface(iface=TeslaReceiverHolder.class, prefix="teslaNetwork$")})
public abstract class TeslaNetworkReceiversPlayerMixin
extends LivingEntity {
    @Unique
    private final Map<WorldPos, PlayerTeslaReceiver> playerReceivers = Maps.newHashMap();

    protected TeslaNetworkReceiversPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public Collection<TeslaReceiver> teslaNetwork$getTeslaReceivers() {
        return Collections.unmodifiableCollection(this.playerReceivers.values());
    }

    @Unique
    private List<ItemStack> getAllItems() {
        Player player = (Player)this;
        Inventory inventory = player.getInventory();
        ArrayList items = Lists.newArrayList();
        items.addAll(inventory.armor);
        items.addAll(inventory.items);
        items.addAll(inventory.offhand);
        items.addAll(((EIModSlotProxy)Proxies.get(EIModSlotProxy.class)).getContents(player, stack -> true));
        return items;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo callback) {
        Player player = (Player)this;
        if (this.level().isClientSide()) {
            return;
        }
        HashSet found = Sets.newHashSet();
        for (ItemStack stack : this.getAllItems()) {
            if (!(stack.getItem() instanceof TeslaHandheldReceiverItem) || !stack.has(EIComponents.SELECTED_TESLA_NETWORK)) continue;
            found.add(((SelectedTeslaNetwork)stack.get(EIComponents.SELECTED_TESLA_NETWORK)).key());
        }
        Sets.SetView toRemove = Sets.difference(this.playerReceivers.keySet(), (Set)found);
        for (WorldPos key : toRemove) {
            PlayerTeslaReceiver receiver = this.playerReceivers.remove(key);
            receiver.getNetwork().remove(receiver);
        }
        Sets.SetView toAdd = Sets.difference((Set)found, this.playerReceivers.keySet());
        for (WorldPos key : toAdd) {
            PlayerTeslaReceiver receiver = new PlayerTeslaReceiver(player, key);
            receiver.getNetwork().add(receiver);
            this.playerReceivers.put(key, receiver);
        }
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    private void remove(Entity.RemovalReason reason, CallbackInfo callback) {
        if (this.level().isClientSide()) {
            return;
        }
        this.playerReceivers.forEach((key, receiver) -> receiver.getNetwork().remove((TeslaReceiver)receiver));
        this.playerReceivers.clear();
    }
}

