/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.text.markdown.ScrollableMarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class CreditsScreen
extends Screen {
    private static final ResourceSource CREDITS_SOURCE = ResourceSource.of("fancymenu:credits_and_copyright.md", ResourceSourceType.LOCATION);
    protected ScrollableMarkdownRenderer markdownRenderer;
    protected int headerHeight = 20;
    protected int footerHeight = 40;
    protected int border = 40;
    protected Screen parent;
    protected boolean textSet = false;
    protected ResourceSupplier<IText> creditsTextSupplier = ResourceSupplier.text(CREDITS_SOURCE.getSerializationSource());

    public CreditsScreen(@NotNull Screen parent) {
        super((Component)Component.empty());
        this.parent = parent;
    }

    protected void init() {
        int centerX = this.width / 2;
        int scrollWidth = this.width - this.border * 2;
        int scrollHeight = this.height - this.headerHeight - this.footerHeight;
        if (this.markdownRenderer == null) {
            this.markdownRenderer = new ScrollableMarkdownRenderer(centerX - scrollWidth / 2, this.headerHeight, scrollWidth, scrollHeight);
        } else {
            this.markdownRenderer.rebuild(centerX - scrollWidth / 2, this.headerHeight, scrollWidth, scrollHeight);
        }
        this.markdownRenderer.getMarkdownRenderer().setHeadlineLineColor(UIBase.getUIColorTheme().screen_background_color_darker);
        this.markdownRenderer.getMarkdownRenderer().setTextBaseColor(UIBase.getUIColorTheme().generic_text_base_color);
        this.markdownRenderer.getMarkdownRenderer().setTextShadow(false);
        this.addRenderableWidget((GuiEventListener)this.markdownRenderer);
        UIBase.applyDefaultWidgetSkinTo((ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(centerX - 100, this.height - this.footerHeight / 2 - 10, 200, 20, (Component)Component.translatable((String)"fancymenu.common.close"), var1 -> this.onClose())));
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        List<String> lines;
        IText text;
        if (!this.textSet && (text = this.creditsTextSupplier.get()) != null && (lines = text.getTextLines()) != null) {
            StringBuilder lineString = new StringBuilder();
            for (String s : lines) {
                lineString.append(s).append("\n");
            }
            this.markdownRenderer.setText(lineString.toString());
            this.textSet = true;
        }
        RenderSystem.enableBlend();
        graphics.fill(0, 0, this.width, this.height, UIBase.getUIColorTheme().screen_background_color_darker.getColorInt());
        RenderingUtils.resetShaderColor(graphics);
        graphics.fill(0, this.height - this.footerHeight, this.width, this.height, UIBase.getUIColorTheme().area_background_color.getColorInt());
        RenderingUtils.resetShaderColor(graphics);
        super.render(graphics, mouseX, mouseY, partial);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int $$1, int $$2, float $$3) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.markdownRenderer.mouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.markdownRenderer.mouseReleased(mouseX, mouseY, button);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }
}

