/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.leveling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.Buddy;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.leveling.BuddyAchievement;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LevelingManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String SAVE_FILENAME = "buddy_leveling.json";
    private static final File BUDDY_DIR = new File(FancyMenu.INSTANCE_DATA_DIR, "buddy");
    private static final int MAX_LEVEL = 30;
    private static final int BASE_XP_PER_LEVEL = 100;
    private static final float LEVEL_SCALING_FACTOR = 1.5f;
    private final Buddy buddy;
    private int currentLevel = 1;
    private int experience = 0;
    private final Map<BuddyAchievement.AchievementType, BuddyAchievement> achievements = new EnumMap<BuddyAchievement.AchievementType, BuddyAchievement>(BuddyAchievement.AchievementType.class);
    private final int[] levelExperience = new int[31];
    private int petCount = 0;
    private int feedCount = 0;
    private int playCount = 0;
    private int poopCleanCount = 0;
    private long totalSessionTime = 0L;
    private long lastSessionStart = 0L;
    private int layoutCreationCount = 0;

    public LevelingManager(@NotNull Buddy buddy) {
        this.buddy = buddy;
        this.initializeAchievements();
        this.initializeLevelExperience();
        this.lastSessionStart = System.currentTimeMillis();
    }

    private void initializeLevelExperience() {
        for (int i = 1; i <= 30; ++i) {
            this.levelExperience[i] = this.calculateExperienceForLevel(i);
        }
    }

    private void initializeAchievements() {
        this.achievements.put(BuddyAchievement.AchievementType.FIRST_STEPS, new BuddyAchievement(BuddyAchievement.AchievementType.FIRST_STEPS, "Interact with your buddy for the first time", 50, null));
        this.achievements.put(BuddyAchievement.AchievementType.FRIENDLY_TOUCH, new BuddyAchievement(BuddyAchievement.AchievementType.FRIENDLY_TOUCH, "Pet your buddy 10 times", 100, null));
        this.achievements.put(BuddyAchievement.AchievementType.CARETAKER, new BuddyAchievement(BuddyAchievement.AchievementType.CARETAKER, "Feed your buddy 5 times", 100, null));
        this.achievements.put(BuddyAchievement.AchievementType.PLAYFUL_FRIEND, new BuddyAchievement(BuddyAchievement.AchievementType.PLAYFUL_FRIEND, "Play with your buddy for the first time", 75, null));
        this.achievements.put(BuddyAchievement.AchievementType.CLEANUP_CREW, new BuddyAchievement(BuddyAchievement.AchievementType.CLEANUP_CREW, "Clean up 5 poops", 75, null));
        this.achievements.put(BuddyAchievement.AchievementType.BEST_BUDDIES, new BuddyAchievement(BuddyAchievement.AchievementType.BEST_BUDDIES, "Reach maximum happiness with your buddy", 200, null));
        this.achievements.put(BuddyAchievement.AchievementType.WELL_FED, new BuddyAchievement(BuddyAchievement.AchievementType.WELL_FED, "Keep your buddy perfectly fed for a full session", 200, null));
        this.achievements.put(BuddyAchievement.AchievementType.ENERGIZER, new BuddyAchievement(BuddyAchievement.AchievementType.ENERGIZER, "Keep your buddy's energy above 80% for an entire session", 200, null));
        this.achievements.put(BuddyAchievement.AchievementType.FUN_TIMES, new BuddyAchievement(BuddyAchievement.AchievementType.FUN_TIMES, "Reach maximum fun level with your buddy", 200, null));
        this.achievements.put(BuddyAchievement.AchievementType.MARATHON_SESSION, new BuddyAchievement(BuddyAchievement.AchievementType.MARATHON_SESSION, "Spend over an hour with your buddy in a single session", 300, null));
        this.achievements.put(BuddyAchievement.AchievementType.MASTER_TRAINER, new BuddyAchievement(BuddyAchievement.AchievementType.MASTER_TRAINER, "Reach level 10 with your buddy", 500, null));
        this.achievements.put(BuddyAchievement.AchievementType.COMPLETION_COLLECTOR, new BuddyAchievement(BuddyAchievement.AchievementType.COMPLETION_COLLECTOR, "Unlock all basic achievements", 750, null));
        this.achievements.put(BuddyAchievement.AchievementType.MIDNIGHT_COMPANION, new BuddyAchievement(BuddyAchievement.AchievementType.MIDNIGHT_COMPANION, "Spend time with your buddy after midnight", 250, null));
        this.achievements.put(BuddyAchievement.AchievementType.DESIGN_MARATHON, new BuddyAchievement(BuddyAchievement.AchievementType.DESIGN_MARATHON, "Spend extended time with your buddy", 500, null));
        this.achievements.put(BuddyAchievement.AchievementType.LOYAL_FRIEND, new BuddyAchievement(BuddyAchievement.AchievementType.LOYAL_FRIEND, "Interact with your buddy every day for a week", 1000, null));
        this.achievements.put(BuddyAchievement.AchievementType.PERFECT_HARMONY, new BuddyAchievement(BuddyAchievement.AchievementType.PERFECT_HARMONY, "Keep all buddy stats above 90% for an entire session", 1500, null));
        this.achievements.put(BuddyAchievement.AchievementType.ACHIEVEMENT_HUNTER, new BuddyAchievement(BuddyAchievement.AchievementType.ACHIEVEMENT_HUNTER, "Unlock all other achievements", 5000, null));
    }

    private int calculateExperienceForLevel(int level) {
        if (level <= 1) {
            return 0;
        }
        int totalXp = 0;
        for (int i = 1; i < level; ++i) {
            totalXp += (int)(100.0 * Math.pow(i, 1.5));
        }
        return totalXp;
    }

    public int getExperienceForNextLevel() {
        if (this.currentLevel >= 30) {
            return 0;
        }
        return this.levelExperience[this.currentLevel + 1] - this.experience;
    }

    public int getLevelProgressPercentage() {
        if (this.currentLevel >= 30) {
            return 100;
        }
        int currentLevelXp = this.levelExperience[this.currentLevel];
        int nextLevelXp = this.levelExperience[this.currentLevel + 1];
        int levelXpRange = nextLevelXp - currentLevelXp;
        int currentLevelProgress = this.experience - currentLevelXp;
        return levelXpRange > 0 ? currentLevelProgress * 100 / levelXpRange : 100;
    }

    public List<Integer> addExperience(int amount) {
        if (amount <= 0 || this.currentLevel >= 30) {
            return Collections.emptyList();
        }
        ArrayList<Integer> levelsGained = new ArrayList<Integer>();
        int oldLevel = this.currentLevel;
        this.experience += amount;
        LOGGER.debug("Added {} XP to buddy, total XP: {}", (Object)amount, (Object)this.experience);
        while (this.currentLevel < 30 && this.experience >= this.levelExperience[this.currentLevel + 1]) {
            ++this.currentLevel;
            levelsGained.add(this.currentLevel);
            LOGGER.debug("Buddy leveled up to level {}!", (Object)this.currentLevel);
            this.checkLevelAchievements();
        }
        if (oldLevel != this.currentLevel) {
            this.applyLevelStatBoosts();
        }
        return levelsGained;
    }

    private void applyLevelStatBoosts() {
        this.buddy.standChancePercentage = Math.min(2.0f, 1.0f + (float)this.currentLevel * 0.03f);
        this.buddy.hopChancePercentage = Math.min(1.0f, 0.3f + (float)this.currentLevel * 0.02f);
        this.buddy.lookChancePercentage = Math.min(0.8f, 0.2f + (float)this.currentLevel * 0.02f);
        this.buddy.stretchChancePercentage = Math.min(0.5f, 0.1f + (float)this.currentLevel * 0.01f);
        this.buddy.excitedChancePercentage = Math.min(0.5f, 0.1f + (float)this.currentLevel * 0.01f);
        this.buddy.poopingInterval = Math.max(4000, 6000 - 200 * Math.min(10, this.currentLevel));
        this.buddy.hopAnimationSpeed = 0.3f + 0.01f * (float)Math.min(30, this.currentLevel);
        this.applyLevelEffects();
    }

    public void applyLevelEffects() {
        float levelProgress = (float)Math.min(this.currentLevel, 30) / 30.0f;
        float hungerMultiplier = 1.0f - levelProgress * 0.5f;
        float happinessMultiplier = 1.0f - levelProgress * 0.5f;
        float energyMultiplier = 1.0f - levelProgress * 0.5f;
        float happinessGainMultiplier = 1.0f + levelProgress * 0.5f;
        float experienceMultiplier = 1.0f + levelProgress * 0.3f;
        float needsUnderstandingBonus = levelProgress * 0.5f;
        float luckBonus = levelProgress * 0.4f;
        this.buddy.setAttributeEffects(hungerMultiplier, happinessMultiplier, energyMultiplier, happinessGainMultiplier, experienceMultiplier, needsUnderstandingBonus, luckBonus);
    }

    public void updateSessionTime() {
        long currentTime = System.currentTimeMillis();
        long sessionDuration = (currentTime - this.lastSessionStart) / 1000L;
        this.totalSessionTime += sessionDuration;
        this.lastSessionStart = currentTime;
        this.checkTimeAchievements(currentTime);
    }

    public void incrementPetCount() {
        ++this.petCount;
        if (this.petCount == 1) {
            this.unlockAchievement(BuddyAchievement.AchievementType.FIRST_STEPS);
        }
        if (this.petCount == 10) {
            this.unlockAchievement(BuddyAchievement.AchievementType.FRIENDLY_TOUCH);
        }
    }

    public void incrementFeedCount() {
        ++this.feedCount;
        if (this.feedCount == 5) {
            this.unlockAchievement(BuddyAchievement.AchievementType.CARETAKER);
        }
    }

    public void incrementPlayCount() {
        ++this.playCount;
        if (this.playCount == 1) {
            this.unlockAchievement(BuddyAchievement.AchievementType.PLAYFUL_FRIEND);
        }
    }

    public void incrementPoopCleanCount() {
        ++this.poopCleanCount;
        if (this.poopCleanCount == 5) {
            this.unlockAchievement(BuddyAchievement.AchievementType.CLEANUP_CREW);
        }
    }

    public void incrementLayoutCreationCount() {
        ++this.layoutCreationCount;
        if (this.layoutCreationCount == 10 && this.totalSessionTime > 1800L) {
            this.unlockAchievement(BuddyAchievement.AchievementType.DESIGN_MARATHON);
        }
    }

    private void checkLevelAchievements() {
        if (this.currentLevel >= 10) {
            this.unlockAchievement(BuddyAchievement.AchievementType.MASTER_TRAINER);
        }
    }

    private void checkTimeAchievements(long currentTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(currentTime);
        int hour = calendar.get(11);
        if (hour >= 0 && hour < 4) {
            this.unlockAchievement(BuddyAchievement.AchievementType.MIDNIGHT_COMPANION);
        }
        if (this.totalSessionTime >= 3600L) {
            this.unlockAchievement(BuddyAchievement.AchievementType.MARATHON_SESSION);
        }
    }

    public void checkStatAchievements() {
        if (this.buddy.getHappiness() >= 100.0f) {
            this.unlockAchievement(BuddyAchievement.AchievementType.BEST_BUDDIES);
        }
        if (this.buddy.getFunLevel() >= 100.0f) {
            this.unlockAchievement(BuddyAchievement.AchievementType.FUN_TIMES);
        }
    }

    public boolean unlockAchievement(BuddyAchievement.AchievementType type) {
        BuddyAchievement achievement = this.achievements.get((Object)type);
        if (achievement == null || achievement.isUnlocked()) {
            return false;
        }
        boolean unlocked = achievement.unlock(this);
        if (unlocked) {
            LOGGER.debug("Unlocked achievement: {}", (Object)type.getName());
            this.checkCompletionCollectorAchievement();
            this.checkAchievementHunterAchievement();
        }
        return unlocked;
    }

    private void checkCompletionCollectorAchievement() {
        BuddyAchievement completionCollector;
        boolean allBasicUnlocked = true;
        for (BuddyAchievement achievement : this.achievements.values()) {
            if (achievement.getType().getTier() != 1 || achievement.isUnlocked()) continue;
            allBasicUnlocked = false;
            break;
        }
        if (allBasicUnlocked && (completionCollector = this.achievements.get((Object)BuddyAchievement.AchievementType.COMPLETION_COLLECTOR)) != null && !completionCollector.isUnlocked()) {
            completionCollector.unlock(this);
            LOGGER.debug("Unlocked achievement: {}", (Object)BuddyAchievement.AchievementType.COMPLETION_COLLECTOR.getName());
        }
    }

    private void checkAchievementHunterAchievement() {
        BuddyAchievement achievementHunter;
        boolean allOthersUnlocked = true;
        for (Map.Entry<BuddyAchievement.AchievementType, BuddyAchievement> entry : this.achievements.entrySet()) {
            if (entry.getKey() == BuddyAchievement.AchievementType.ACHIEVEMENT_HUNTER || entry.getValue().isUnlocked()) continue;
            allOthersUnlocked = false;
            break;
        }
        if (allOthersUnlocked && (achievementHunter = this.achievements.get((Object)BuddyAchievement.AchievementType.ACHIEVEMENT_HUNTER)) != null && !achievementHunter.isUnlocked()) {
            achievementHunter.unlock(this);
            LOGGER.debug("Unlocked achievement: {}", (Object)BuddyAchievement.AchievementType.ACHIEVEMENT_HUNTER.getName());
        }
    }

    public boolean saveState() {
        try {
            if (!BUDDY_DIR.exists()) {
                BUDDY_DIR.mkdirs();
            }
            File saveFile = new File(BUDDY_DIR, SAVE_FILENAME);
            JsonObject json = new JsonObject();
            json.addProperty("level", (Number)this.currentLevel);
            json.addProperty("experience", (Number)this.experience);
            JsonObject achievementsObj = new JsonObject();
            for (Map.Entry<BuddyAchievement.AchievementType, BuddyAchievement> entry : this.achievements.entrySet()) {
                JsonObject achievementObj = new JsonObject();
                achievementObj.addProperty("unlocked", Boolean.valueOf(entry.getValue().isUnlocked()));
                achievementObj.addProperty("unlockTimestamp", (Number)entry.getValue().getUnlockTimestamp());
                achievementsObj.add(entry.getKey().name(), (JsonElement)achievementObj);
            }
            json.add("achievements", (JsonElement)achievementsObj);
            JsonObject activityObj = new JsonObject();
            activityObj.addProperty("petCount", (Number)this.petCount);
            activityObj.addProperty("feedCount", (Number)this.feedCount);
            activityObj.addProperty("playCount", (Number)this.playCount);
            activityObj.addProperty("poopCleanCount", (Number)this.poopCleanCount);
            activityObj.addProperty("totalSessionTime", (Number)this.totalSessionTime);
            activityObj.addProperty("layoutCreationCount", (Number)this.layoutCreationCount);
            json.add("activity", (JsonElement)activityObj);
            try (FileWriter writer = new FileWriter(saveFile);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
            LOGGER.debug("Saved buddy leveling data to {}", (Object)saveFile.getAbsolutePath());
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to save buddy leveling data", (Throwable)e);
            return false;
        }
    }

    public boolean loadState() {
        boolean bl;
        File saveFile = new File(BUDDY_DIR, SAVE_FILENAME);
        if (!saveFile.exists()) {
            LOGGER.debug("No buddy leveling save file found at {}", (Object)saveFile.getAbsolutePath());
            return false;
        }
        FileReader reader = new FileReader(saveFile);
        try {
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (json.has("level")) {
                this.currentLevel = json.get("level").getAsInt();
                this.currentLevel = Math.max(1, Math.min(30, this.currentLevel));
            }
            if (json.has("experience")) {
                this.experience = json.get("experience").getAsInt();
                this.experience = Math.max(this.calculateExperienceForLevel(this.currentLevel), this.experience);
            }
            if (json.has("achievements")) {
                JsonObject achievementsObj = json.getAsJsonObject("achievements");
                for (BuddyAchievement.AchievementType type : BuddyAchievement.AchievementType.values()) {
                    if (!achievementsObj.has(type.name())) continue;
                    JsonObject achievementObj = achievementsObj.getAsJsonObject(type.name());
                    BuddyAchievement achievement = this.achievements.get((Object)type);
                    if (achievement == null || !achievementObj.has("unlocked") || !achievementObj.get("unlocked").getAsBoolean()) continue;
                    achievement.reset();
                    achievement.unlock(this);
                }
            }
            if (json.has("activity")) {
                JsonObject activityObj = json.getAsJsonObject("activity");
                if (activityObj.has("petCount")) {
                    this.petCount = activityObj.get("petCount").getAsInt();
                }
                if (activityObj.has("feedCount")) {
                    this.feedCount = activityObj.get("feedCount").getAsInt();
                }
                if (activityObj.has("playCount")) {
                    this.playCount = activityObj.get("playCount").getAsInt();
                }
                if (activityObj.has("poopCleanCount")) {
                    this.poopCleanCount = activityObj.get("poopCleanCount").getAsInt();
                }
                if (activityObj.has("totalSessionTime")) {
                    this.totalSessionTime = activityObj.get("totalSessionTime").getAsLong();
                }
                if (activityObj.has("layoutCreationCount")) {
                    this.layoutCreationCount = activityObj.get("layoutCreationCount").getAsInt();
                }
            }
            this.applyLevelStatBoosts();
            LOGGER.debug("Loaded buddy leveling data from {}", (Object)saveFile.getAbsolutePath());
            LOGGER.debug("Current level: {}, Experience: {}", (Object)this.currentLevel, (Object)this.experience);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("Failed to load buddy leveling data", e);
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public int getExperience() {
        return this.experience;
    }

    public Map<BuddyAchievement.AchievementType, BuddyAchievement> getAchievements() {
        return new EnumMap<BuddyAchievement.AchievementType, BuddyAchievement>(this.achievements);
    }

    public int getPetCount() {
        return this.petCount;
    }

    public int getFeedCount() {
        return this.feedCount;
    }

    public int getPlayCount() {
        return this.playCount;
    }

    public int getPoopCleanCount() {
        return this.poopCleanCount;
    }

    public long getTotalSessionTime() {
        return this.totalSessionTime;
    }

    public int getLayoutCreationCount() {
        return this.layoutCreationCount;
    }
}

