/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.gui;

import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.Executable;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseIfExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.IfExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.WhileExecutableBlock;
import de.keksuccino.fancymenu.customization.action.ui.ActionScriptEditorScreen;
import de.keksuccino.fancymenu.customization.listener.ListenerHandler;
import de.keksuccino.fancymenu.customization.listener.ListenerInstance;
import de.keksuccino.fancymenu.customization.listener.gui.ChooseListenerTypeScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.cursor.CursorHandler;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageListenersScreen
extends CellScreen {
    @NotNull
    protected final Consumer<Boolean> callback;
    @NotNull
    protected final List<ListenerInstance> tempInstances = new ArrayList<ListenerInstance>();
    @Nullable
    protected ListenerInstance selectedInstance;

    public ManageListenersScreen(@NotNull Consumer<Boolean> callback) {
        super((Component)Component.translatable((String)"fancymenu.listeners.manage"));
        this.callback = callback;
        this.tempInstances.addAll(ListenerHandler.getInstances());
        this.setSearchBarEnabled(true);
        this.setDescriptionAreaEnabled(true);
    }

    @Override
    protected void initCells() {
        String editingInstanceId = null;
        String editingValue = null;
        for (Object cell2 : this.allCells) {
            if (!(cell2 instanceof ListenerInstanceCell)) continue;
            ListenerInstanceCell instanceCell = (ListenerInstanceCell)((Object)cell2);
            if (!instanceCell.editMode || instanceCell.editBox == null) continue;
            editingInstanceId = instanceCell.instance.instanceIdentifier;
            editingValue = instanceCell.editBox.getValue();
            break;
        }
        this.addSpacerCell(5).setIgnoreSearch();
        ArrayList<ListenerInstanceCell> instanceCells = new ArrayList<ListenerInstanceCell>();
        for (ListenerInstance instance : this.tempInstances) {
            ListenerInstanceCell cell3 = new ListenerInstanceCell(instance);
            instanceCells.add(cell3);
        }
        instanceCells.sort(Comparator.comparing(cell -> cell.labelComponent.getString(), String.CASE_INSENSITIVE_ORDER).thenComparing(cell -> cell.labelComponent.getString()).thenComparing(cell -> cell.instance.instanceIdentifier));
        String finalEditingInstanceId = editingInstanceId;
        String finalEditingValue = editingValue;
        instanceCells.forEach(cell -> {
            this.addCell(cell).setSelectable(true);
            if (finalEditingInstanceId != null && finalEditingInstanceId.equals(cell.instance.instanceIdentifier)) {
                cell.enterEditMode();
                if (cell.editBox != null && finalEditingValue != null) {
                    cell.editBox.setValue(finalEditingValue);
                    cell.editBox.setCursorPosition(finalEditingValue.length());
                }
            }
        });
        this.addSpacerCell(5).setIgnoreSearch();
    }

    @Override
    protected void initRightSideWidgets() {
        this.addRightSideButton(20, (Component)Component.translatable((String)"fancymenu.listeners.manage.add"), button -> {
            ChooseListenerTypeScreen chooseScreen = new ChooseListenerTypeScreen(listener -> {
                if (listener != null) {
                    ListenerInstance newInstance = listener.createFreshInstance();
                    ActionScriptEditorScreen actionsScreen = new ActionScriptEditorScreen(newInstance.getActionScript(), updatedScript -> {
                        if (updatedScript != null) {
                            newInstance.setActionScript((GenericExecutableBlock)updatedScript);
                            this.tempInstances.add(newInstance);
                            this.rebuild();
                        }
                        Minecraft.getInstance().setScreen((Screen)this);
                    });
                    Minecraft.getInstance().setScreen((Screen)actionsScreen);
                } else {
                    Minecraft.getInstance().setScreen((Screen)this);
                }
            });
            Minecraft.getInstance().setScreen((Screen)chooseScreen);
        });
        this.addRightSideButton(20, (Component)Component.translatable((String)"fancymenu.listeners.manage.edit"), button -> this.onEditActionsOfSelected()).setIsActiveSupplier(consumes -> this.selectedInstance != null);
        this.addRightSideButton(20, (Component)Component.translatable((String)"fancymenu.listeners.manage.remove"), button -> {
            ListenerInstance sel = this.selectedInstance;
            if (sel != null) {
                Minecraft.getInstance().setScreen((Screen)ConfirmationScreen.critical(call -> {
                    if (call.booleanValue()) {
                        this.tempInstances.remove(sel);
                        this.selectedInstance = null;
                        this.rebuild();
                    }
                    Minecraft.getInstance().setScreen((Screen)this);
                }, new Component[]{Component.translatable((String)"fancymenu.listeners.manage.delete_warning")}));
            }
        }).setIsActiveSupplier(consumes -> this.selectedInstance != null);
    }

    protected void onEditActionsOfSelected() {
        if (this.selectedInstance != null) {
            ListenerInstance cached = this.selectedInstance;
            ActionScriptEditorScreen actionsScreen = new ActionScriptEditorScreen(cached.getActionScript(), updatedScript -> {
                if (updatedScript != null) {
                    cached.setActionScript((GenericExecutableBlock)updatedScript);
                }
                Minecraft.getInstance().setScreen((Screen)this);
            });
            Minecraft.getInstance().setScreen((Screen)actionsScreen);
        }
    }

    @Override
    @Nullable
    protected List<Component> getCurrentDescription() {
        this.updateSelectedInstance();
        List<Component> desc = super.getCurrentDescription();
        if (desc == null) {
            return null;
        }
        if (this.selectedInstance == null) {
            return null;
        }
        ArrayList<Component> newDesc = new ArrayList<Component>();
        newDesc.add((Component)Component.translatable((String)"fancymenu.listeners.manage.description.listener_desc").withStyle(ChatFormatting.BOLD));
        newDesc.add((Component)Component.literal((String)"(").append(this.selectedInstance.parent.getDisplayName()).append(")"));
        newDesc.add((Component)Component.empty());
        newDesc.addAll(desc);
        newDesc.add((Component)Component.empty());
        newDesc.add((Component)Component.empty());
        newDesc.add((Component)Component.translatable((String)"fancymenu.listeners.manage.description.actions").withStyle(ChatFormatting.BOLD));
        newDesc.add((Component)Component.empty());
        List<Component> actionLines = this.buildActionScriptDescription(this.selectedInstance.getActionScript(), 0);
        newDesc.addAll(actionLines);
        return newDesc;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public boolean allowEnterForDone() {
        return false;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.updateSelectedInstance();
        super.render(graphics, mouseX, mouseY, partial);
        if (this.descriptionScrollArea != null) {
            int lineX;
            int lineWidth;
            int descW = (int)this.descriptionScrollArea.getWidthWithBorder();
            int descEndX = (int)(this.descriptionScrollArea.getXWithBorder() + this.descriptionScrollArea.getWidthWithBorder());
            int descEndY = (int)(this.descriptionScrollArea.getYWithBorder() + this.descriptionScrollArea.getHeightWithBorder());
            List renameTip = this.font.split((FormattedText)Component.translatable((String)"fancymenu.listeners.manage.rename_tip").withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_inactive.getColorInt()).withItalic(Boolean.valueOf(true))), descW);
            List quickEditTip = this.font.split((FormattedText)Component.translatable((String)"fancymenu.listeners.manage.quick_edit_tip").withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_inactive.getColorInt()).withItalic(Boolean.valueOf(true))), descW);
            int lineY = descEndY + 4;
            for (FormattedCharSequence line : renameTip) {
                lineWidth = this.font.width(line);
                lineX = descEndX - lineWidth;
                graphics.drawString(this.font, line, lineX, lineY, -1, false);
                Objects.requireNonNull(this.font);
                lineY += 9 + 2;
            }
            lineY += 2;
            for (FormattedCharSequence line : quickEditTip) {
                lineWidth = this.font.width(line);
                lineX = descEndX - lineWidth;
                graphics.drawString(this.font, line, lineX, lineY, -1, false);
                Objects.requireNonNull(this.font);
                lineY += 9 + 2;
            }
        }
    }

    @Override
    protected void onCancel() {
        Minecraft.getInstance().setScreen((Screen)ConfirmationScreen.critical(callback -> {
            if (callback.booleanValue()) {
                this.callback.accept(false);
            } else {
                Minecraft.getInstance().setScreen((Screen)this);
            }
        }, new Component[]{Component.translatable((String)"fancymenu.listeners.manage.cancel_warning")}));
    }

    @Override
    protected void onDone() {
        for (ListenerInstance instance : new ArrayList<ListenerInstance>(ListenerHandler.getInstances())) {
            ListenerHandler.removeInstance(instance.instanceIdentifier);
        }
        for (ListenerInstance instance : this.tempInstances) {
            ListenerHandler.addInstance(instance);
        }
        this.callback.accept(true);
    }

    protected void updateSelectedInstance() {
        this.updateSelectedCell();
        CellScreen.RenderCell selected = this.getSelectedCell();
        if (selected instanceof ListenerInstanceCell) {
            ListenerInstanceCell cell = (ListenerInstanceCell)selected;
            this.selectedInstance = cell.instance;
        } else {
            this.selectedInstance = null;
        }
    }

    @NotNull
    protected List<Component> buildActionScriptDescription(@NotNull GenericExecutableBlock block, int indentLevel) {
        ArrayList<Component> lines = new ArrayList<Component>();
        for (Executable executable : block.getExecutables()) {
            lines.addAll(this.buildExecutableDescription(executable, indentLevel));
        }
        if (lines.isEmpty()) {
            String indent = "  ".repeat(Math.max(0, indentLevel));
            lines.add((Component)Component.literal((String)(indent + "\u2022 ")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().listing_dot_color_1.getColorInt())).append((Component)Component.translatable((String)"fancymenu.actions.screens.manage_screen.info.value.none").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt()))));
        }
        return lines;
    }

    @NotNull
    protected List<Component> buildExecutableDescription(@NotNull Executable executable, int indentLevel) {
        ArrayList<Component> lines = new ArrayList<Component>();
        String indent = "  ".repeat(Math.max(0, indentLevel));
        if (executable instanceof ActionInstance) {
            ActionInstance actionInstance = (ActionInstance)executable;
            lines.add((Component)Component.literal((String)(indent + "\u2022 ")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().listing_dot_color_2.getColorInt())).append((Component)actionInstance.action.getActionDisplayName().copy().setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
            String cachedValue = actionInstance.value;
            String valueString = cachedValue != null && actionInstance.action.hasValue() ? cachedValue : I18n.get((String)"fancymenu.actions.screens.manage_screen.info.value.none", (Object[])new Object[0]);
            lines.add((Component)Component.literal((String)(indent + "    \u25e6 ")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().listing_dot_color_1.getColorInt())).append((Component)Component.literal((String)(I18n.get((String)"fancymenu.actions.screens.manage_screen.info.value", (Object[])new Object[0]) + " ")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt()))).append((Component)Component.literal((String)valueString).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
        } else if (executable instanceof IfExecutableBlock) {
            IfExecutableBlock ifBlock = (IfExecutableBlock)executable;
            String requirements = this.buildRequirementsString(ifBlock);
            lines.add((Component)Component.literal((String)(indent + "\u2022 ")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt())).append((Component)Component.translatable((String)"fancymenu.actions.blocks.if", (Object[])new Object[]{Component.literal((String)requirements)}).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
            for (Executable nested : ifBlock.getExecutables()) {
                lines.addAll(this.buildExecutableDescription(nested, indentLevel + 1));
            }
            for (AbstractExecutableBlock appended = ifBlock.getAppendedBlock(); appended != null; appended = appended.getAppendedBlock()) {
                lines.addAll(this.buildAppendedBlockDescription(appended, indentLevel));
            }
        } else if (executable instanceof WhileExecutableBlock) {
            WhileExecutableBlock whileBlock = (WhileExecutableBlock)executable;
            String requirements = this.buildRequirementsString(whileBlock);
            lines.add((Component)Component.literal((String)(indent + "\u2022 ")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt())).append((Component)Component.translatable((String)"fancymenu.actions.blocks.while", (Object[])new Object[]{Component.literal((String)requirements)}).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
            for (Executable nested : whileBlock.getExecutables()) {
                lines.addAll(this.buildExecutableDescription(nested, indentLevel + 1));
            }
        } else if (executable instanceof AbstractExecutableBlock) {
            lines.add((Component)Component.literal((String)(indent + "\u2022 ")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt())).append((Component)Component.literal((String)"[UNKNOWN BLOCK]").setStyle(Style.EMPTY.withColor(ChatFormatting.RED))));
        }
        return lines;
    }

    @NotNull
    protected List<Component> buildAppendedBlockDescription(@NotNull AbstractExecutableBlock block, int indentLevel) {
        ArrayList<Component> lines;
        block3: {
            String indent;
            block2: {
                lines = new ArrayList<Component>();
                indent = "  ".repeat(Math.max(0, indentLevel));
                if (!(block instanceof ElseIfExecutableBlock)) break block2;
                ElseIfExecutableBlock elseIfBlock = (ElseIfExecutableBlock)block;
                String requirements = this.buildRequirementsString(elseIfBlock);
                lines.add((Component)Component.literal((String)(indent + "\u2022 ")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt())).append((Component)Component.translatable((String)"fancymenu.actions.blocks.else_if", (Object[])new Object[]{Component.literal((String)requirements)}).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
                for (Executable nested : elseIfBlock.getExecutables()) {
                    lines.addAll(this.buildExecutableDescription(nested, indentLevel + 1));
                }
                break block3;
            }
            if (!(block instanceof ElseExecutableBlock)) break block3;
            ElseExecutableBlock elseBlock = (ElseExecutableBlock)block;
            lines.add((Component)Component.literal((String)(indent + "\u2022 ")).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt())).append((Component)Component.translatable((String)"fancymenu.actions.blocks.else").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))));
            for (Executable nested : elseBlock.getExecutables()) {
                lines.addAll(this.buildExecutableDescription(nested, indentLevel + 1));
            }
        }
        return lines;
    }

    @NotNull
    protected String buildRequirementsString(@NotNull IfExecutableBlock block) {
        Object requirements = "";
        for (LoadingRequirementGroup g : block.condition.getGroups()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + g.identifier;
        }
        for (LoadingRequirementInstance i : block.condition.getInstances()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + i.requirement.getDisplayName();
        }
        return ((String)requirements).isEmpty() ? "none" : requirements;
    }

    @NotNull
    protected String buildRequirementsString(@NotNull ElseIfExecutableBlock block) {
        Object requirements = "";
        for (LoadingRequirementGroup g : block.condition.getGroups()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + g.identifier;
        }
        for (LoadingRequirementInstance i : block.condition.getInstances()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + i.requirement.getDisplayName();
        }
        return ((String)requirements).isEmpty() ? "none" : requirements;
    }

    @NotNull
    protected String buildRequirementsString(@NotNull WhileExecutableBlock block) {
        Object requirements = "";
        for (LoadingRequirementGroup g : block.condition.getGroups()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + g.identifier;
        }
        for (LoadingRequirementInstance i : block.condition.getInstances()) {
            if (!((String)requirements).isEmpty()) {
                requirements = (String)requirements + ", ";
            }
            requirements = (String)requirements + i.requirement.getDisplayName();
        }
        return ((String)requirements).isEmpty() ? "none" : requirements;
    }

    public class ListenerInstanceCell
    extends CellScreen.RenderCell {
        @NotNull
        protected final ListenerInstance instance;
        @NotNull
        protected Component labelComponent;
        @Nullable
        protected ExtendedEditBox editBox;
        protected boolean editMode;
        protected long lastClickTime;
        protected static final long DOUBLE_CLICK_TIME = 500L;
        protected static final int TOP_DOWN_CELL_BORDER = 1;

        public ListenerInstanceCell(ListenerInstance instance) {
            super(ManageListenersScreen.this);
            this.editMode = false;
            this.lastClickTime = 0L;
            this.instance = instance;
            this.updateLabelComponent();
            this.setDescriptionSupplier(this.instance.parent::getDescription);
            this.setSearchStringSupplier(() -> {
                if (this.instance.getDisplayName() != null) {
                    return this.instance.getDisplayName();
                }
                return this.instance.parent.getDisplayName().getString();
            });
        }

        protected void updateLabelComponent() {
            this.labelComponent = this.instance.getDisplayName() != null && !this.instance.getDisplayName().isBlank() ? Component.literal((String)this.instance.getDisplayName()).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_normal.getColorInt())) : this.instance.parent.getDisplayName().copy().setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
        }

        @Override
        public void renderCell(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            if (this.editMode && this.editBox != null) {
                this.editBox.setX(this.getX());
                this.editBox.setY(this.getY() + 1);
                this.editBox.setWidth(Math.min(this.getWidth(), 200));
                Objects.requireNonNull(Minecraft.getInstance().font);
                this.editBox.setHeight(9 + 1);
                this.editBox.render(graphics, mouseX, mouseY, partial);
                if (MouseInput.isLeftMouseDown() && !this.editBox.isHovered()) {
                    this.exitEditMode(true);
                }
            } else {
                RenderingUtils.resetShaderColor(graphics);
                UIBase.drawElementLabel(graphics, Minecraft.getInstance().font, this.labelComponent, this.getX(), this.getY() + 1);
                RenderingUtils.resetShaderColor(graphics);
                int n = this.getX();
                int n2 = this.getY() + 1;
                int n3 = Minecraft.getInstance().font.width((FormattedText)this.labelComponent);
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (UIBase.isXYInArea(mouseX, mouseY, n, n2, n3, 9)) {
                    CursorHandler.setClientTickCursor(CursorHandler.CURSOR_WRITING);
                }
            }
        }

        @Override
        protected void updateSize(@NotNull CellScreen.CellScrollEntry scrollEntry) {
            if (this.editMode && this.editBox != null) {
                this.setWidth(Math.min((int)(ManageListenersScreen.this.scrollArea.getInnerWidth() - 40.0f), 200));
            } else {
                this.setWidth(Minecraft.getInstance().font.width((FormattedText)this.labelComponent));
            }
            Objects.requireNonNull(Minecraft.getInstance().font);
            this.setHeight(9 + 2);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0 && this.isHovered() && !this.editMode) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastClickTime < 500L) {
                    this.enterEditMode();
                    this.lastClickTime = 0L;
                } else {
                    this.lastClickTime = currentTime;
                }
            }
            boolean b = super.mouseClicked(mouseX, mouseY, button);
            if (button == 1 && this.isHovered() && !this.editMode) {
                MainThreadTaskExecutor.executeInMainThread(() -> MainThreadTaskExecutor.executeInMainThread(() -> {
                    this.setSelected(true);
                    ManageListenersScreen.this.updateSelectedInstance();
                    ManageListenersScreen.this.onEditActionsOfSelected();
                }, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK), MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
            }
            return b;
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (this.editMode && this.editBox != null) {
                if (keyCode == 257 || keyCode == 335) {
                    this.exitEditMode(true);
                    return true;
                }
                if (keyCode == 256) {
                    this.exitEditMode(false);
                    return true;
                }
                return this.editBox.keyPressed(keyCode, scanCode, modifiers);
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean charTyped(char codePoint, int modifiers) {
            if (this.editMode && this.editBox != null) {
                return this.editBox.charTyped(codePoint, modifiers);
            }
            return super.charTyped(codePoint, modifiers);
        }

        protected void enterEditMode() {
            if (this.editMode) {
                return;
            }
            this.editMode = true;
            this.editBox = new ExtendedEditBox(Minecraft.getInstance().font, this.getX(), this.getY(), Math.min(200, (int)(ManageListenersScreen.this.scrollArea.getInnerWidth() - 40.0f)), 18, (Component)Component.empty());
            UIBase.applyDefaultWidgetSkinTo(this.editBox);
            this.editBox.setMaxLength(100000);
            String currentName = this.instance.getDisplayName();
            if (currentName != null) {
                this.editBox.setValue(currentName);
            } else {
                this.editBox.setValue("");
            }
            this.editBox.setFocused(true);
            this.editBox.setCursorPosition(this.editBox.getValue().length());
            this.editBox.setHighlightPos(0);
            this.children.clear();
            this.children.add(this.editBox);
        }

        protected void exitEditMode(boolean save) {
            if (!this.editMode || this.editBox == null) {
                return;
            }
            if (save) {
                String newName = this.editBox.getValue();
                if (newName.isBlank()) {
                    this.instance.setDisplayName(null);
                } else {
                    this.instance.setDisplayName(newName);
                }
                this.updateLabelComponent();
                if (ManageListenersScreen.this.selectedInstance == this.instance) {
                    ManageListenersScreen.this.updateDescriptionArea();
                }
            }
            this.editMode = false;
            this.editBox = null;
            this.children.clear();
        }
    }
}

