/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.other;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.Pair;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.TaskExecutor;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomTextPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long CONTENT_RELOAD_COOLDOWN_MS = 30000L;
    private static final Map<String, Pair<Long, List<String>>> CONTENT_CACHE = new ConcurrentHashMap<String, Pair<Long, List<String>>>();
    private static final Set<String> LOADING_SOURCES = Collections.synchronizedSet(new HashSet());
    public static Map<String, RandomTextPackage> randomTextIntervals = new HashMap<String, RandomTextPackage>();

    public RandomTextPlaceholder() {
        super("randomtext");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        RandomTextPackage p;
        String sourceString = dps.values.get("source");
        if (sourceString == null) {
            sourceString = dps.values.get("path");
        }
        long intervalRaw = SerializationUtils.deserializeNumber(Long.class, 10L, dps.values.get("interval"));
        if (sourceString == null) {
            return null;
        }
        List<String> lines = this.getCachedOrLoadContent(sourceString);
        if (lines == null || lines.isEmpty()) {
            return "";
        }
        long interval = intervalRaw * 1000L;
        if (interval < 0L) {
            interval = 0L;
        }
        long currentTime = System.currentTimeMillis();
        if (randomTextIntervals.containsKey(sourceString)) {
            p = randomTextIntervals.get(sourceString);
        } else {
            p = new RandomTextPackage();
            randomTextIntervals.put(sourceString, p);
        }
        if ((interval > 0L || p.currentText == null) && p.lastChange + interval <= currentTime) {
            p.lastChange = currentTime;
            p.currentText = lines.get(MathUtils.getRandomNumberInRange((int)0, (int)(lines.size() - 1)));
        }
        return p.currentText != null ? p.currentText : "";
    }

    private List<String> getCachedOrLoadContent(String pathOrUrl) {
        Pair<Long, List<String>> cached = CONTENT_CACHE.get(pathOrUrl);
        long currentTime = System.currentTimeMillis();
        if (cached != null) {
            if (this.isPlainText(pathOrUrl)) {
                return cached.getValue();
            }
            if (currentTime - cached.getKey() < 30000L) {
                return cached.getValue();
            }
            if (!LOADING_SOURCES.contains(pathOrUrl)) {
                this.triggerAsyncLoad(pathOrUrl);
            }
            return cached.getValue();
        }
        if (!LOADING_SOURCES.contains(pathOrUrl)) {
            this.triggerAsyncLoad(pathOrUrl);
        }
        return null;
    }

    private void triggerAsyncLoad(String pathOrUrl) {
        LOADING_SOURCES.add(pathOrUrl);
        TaskExecutor.execute(() -> {
            try {
                List<String> lines = this.isUrl(pathOrUrl) ? this.loadFromUrl(pathOrUrl) : (this.isPlainText(pathOrUrl) ? this.parsePlainText(pathOrUrl) : this.loadFromFile(pathOrUrl));
                CONTENT_CACHE.put(pathOrUrl, Pair.of(System.currentTimeMillis(), lines));
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Failed to read source for RandomTextPlaceholder: " + pathOrUrl, (Throwable)e);
                CONTENT_CACHE.put(pathOrUrl, Pair.of(System.currentTimeMillis(), new ArrayList()));
            }
            finally {
                LOADING_SOURCES.remove(pathOrUrl);
            }
        }, false);
    }

    private boolean isUrl(String path) {
        return path != null && (path.startsWith("http://") || path.startsWith("https://"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> loadFromUrl(String url) {
        if (!WebUtils.isInternetAvailable()) {
            return new ArrayList<String>();
        }
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStream stream = WebUtils.openResourceStream(url);){
            if (stream == null) {
                LOGGER.warn("[FANCYMENU] Failed to open URL stream: " + url);
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
                return lines;
            }
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error reading from URL: " + url, (Throwable)e);
        }
        return lines;
    }

    private List<String> loadFromFile(String pathString) {
        try {
            File path = new File(ResourceSource.of(pathString, ResourceSourceType.LOCAL).getSourceWithoutPrefix());
            if (!path.isFile() || !path.getPath().toLowerCase().endsWith(".txt")) {
                LOGGER.warn("[FANCYMENU] File not found or not a .txt file: " + pathString);
                return new ArrayList<String>();
            }
            ArrayList<String> lines = new ArrayList<String>();
            lines.addAll(Files.readAllLines(path.toPath(), StandardCharsets.UTF_8));
            return lines;
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error reading file: " + pathString, (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private boolean isPlainText(String path) {
        if (this.isUrl(path)) {
            return false;
        }
        if (path.contains("\\n")) {
            return true;
        }
        boolean looksLikeFilePath = path.trim().toLowerCase().endsWith(".txt");
        return !looksLikeFilePath;
    }

    private List<String> parsePlainText(String plainText) {
        String[] lines = plainText.split("\\\\n");
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            result.add(line);
        }
        if (result.isEmpty()) {
            result.add(plainText);
        }
        return result;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("path");
        l.add("source");
        l.add("interval");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.randomtext", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.randomtext.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.requirements.categories.other", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("source", "/config/fancymenu/assets/<file_name.txt>");
        values.put("interval", "10");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

    public static class RandomTextPackage {
        public String currentText = null;
        public long lastChange = 0L;
    }
}

