/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.client.elytra;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sts15.fargos.items.crafted.BasicElytraItem;
import com.sts15.fargos.items.providers.Soul_of_Flight_Mastery_Provider;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class MyElytraLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final ElytraModel<AbstractClientPlayer> elytraModel = new ElytraModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.ELYTRA));

    public MyElytraLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation textureToRender = null;
        Optional elytraCurio = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof BasicElytraItem, (LivingEntity)player);
        Optional slotResultOptional = CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(inv -> inv.findFirstCurio(stack -> stack.getItem() instanceof BasicElytraItem));
        if (slotResultOptional.isEmpty()) {
            return;
        }
        SlotResult slotResult = (SlotResult)slotResultOptional.get();
        if (!slotResult.slotContext().visible()) {
            return;
        }
        if (elytraCurio.isPresent()) {
            ItemStack stack2 = (ItemStack)((ImmutableTriple)elytraCurio.get()).getRight();
            BasicElytraItem elytraItem = (BasicElytraItem)stack2.getItem();
            textureToRender = elytraItem.getElytraTexture();
        } else {
            boolean hasSoul = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Soul_of_Flight_Mastery_Provider, (LivingEntity)player).isPresent();
            if (hasSoul && (player.isFallFlying() || player.getAbilities().flying)) {
                textureToRender = ResourceLocation.fromNamespaceAndPath((String)"fargos", (String)"textures/entity/elytra/soul_of_flight_mastery.png");
            }
        }
        if (textureToRender == null) {
            return;
        }
        ((PlayerModel)this.getParentModel()).copyPropertiesTo(this.elytraModel);
        this.elytraModel.setupAnim((LivingEntity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)textureToRender));
        this.elytraModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
    }
}

