/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.effect.talismans;

import com.sts15.eventslib.effect.MobEffectEndEffect;
import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.items.souls.Soul_of_Flight_Mastery;
import com.sts15.fargos.utils.TalismanUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class SoulOfFlightMasteryEffect
extends MobEffectEndEffect {
    public SoulOfFlightMasteryEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        super.onEffectAdded(entity, amplifier);
        if (entity instanceof ServerPlayer && TalismanUtil.isTalismanEnabled((ServerPlayer)entity, "soul_of_flight_mastery")) {
            Soul_of_Flight_Mastery.enableFlight((Player)entity);
        }
    }

    public void onEffectRemoved(LivingEntity entity, int amplifier) {
        super.onEffectRemoved(entity, amplifier);
        if (entity instanceof Player) {
            Soul_of_Flight_Mastery.disableFlight((Player)entity);
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                if (player2.tickCount % 10 == 0 && player2.hasEffect(EffectsInit.SOUL_OF_FLIGHT_MASTERY_EFFECT)) {
                    if (TalismanUtil.isTalismanEnabled(player2, "soul_of_colossus")) {
                        Soul_of_Flight_Mastery.enableFlight((Player)player2);
                    } else {
                        Soul_of_Flight_Mastery.disableFlight((Player)player2);
                    }
                }
            }
        }
    }
}

