/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items;

import com.sts15.fargos.init.SoundRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class TalismanItem
extends Item
implements ICurioItem {
    public TalismanItem(Item.Properties properties) {
        super(properties.stacksTo(1).fireResistant());
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        String key;
        this.playEquipSound(slotContext, stack);
        Player player = (Player)slotContext.entity();
        if (!player.level().isClientSide && (key = this.getFirstTimeMessageKey()) != null && !player.getPersistentData().getBoolean(key)) {
            Component msg = this.getFirstTimeMessageComponent();
            if (msg != null) {
                player.sendSystemMessage(msg);
            }
            player.getPersistentData().putBoolean(key, true);
        }
    }

    protected String getFirstTimeMessageKey() {
        return null;
    }

    protected Component getFirstTimeMessageComponent() {
        return null;
    }

    public void onUnequip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        this.playUnequipSound(slotContext, stack);
    }

    private void playEquipSound(SlotContext slotContext, ItemStack stack) {
        Level level = slotContext.entity().level();
        if (!level.isClientSide) {
            Player player = (Player)slotContext.entity();
            level.playSound(null, player.blockPosition(), SoundRegistry.EQUIP_TALISMAN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private void playUnequipSound(SlotContext slotContext, ItemStack stack) {
        Level level = slotContext.entity().level();
        if (!level.isClientSide) {
            Player player = (Player)slotContext.entity();
            level.playSound(null, player.blockPosition(), SoundRegistry.UNEQUIP_TALISMAN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

