/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.looted;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Shiny_Stone_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

@EventBusSubscriber(modid="fargostalismans")
public class ShinyStoneItem
extends TalismanItem
implements Shiny_Stone_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    private static final String charmName = "shiny_stone";
    private static final long STILL_THRESHOLD_TICKS = 600L;
    private static final int REGEN_DURATION_TICKS = 40;
    private static final int REGEN_AMPLIFIER = 0;
    private static final Map<UUID, BlockPos> lastPositions = new HashMap<UUID, BlockPos>();
    private static final Map<UUID, Long> lastMovementTimes = new HashMap<UUID, Long>();
    private static final Set<UUID> shinyStoneActivePlayers = new HashSet<UUID>();

    public ShinyStoneItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.shiny_stone").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!ShinyStoneItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Error checking config status for shiny_stone", (Throwable)e);
        }
        return isEnabled;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID playerId = player2.getUUID();
        long currentTick = player2.level().getGameTime();
        boolean hasShinyStoneEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Shiny_Stone_Provider, (LivingEntity)player2).isPresent();
        if (!hasShinyStoneEquipped || !ShinyStoneItem.checkConfigEnabledStatus()) {
            ShinyStoneItem.removeShinyStoneEffect((Player)player2);
            lastPositions.remove(playerId);
            lastMovementTimes.remove(playerId);
            return;
        }
        if (!TalismanUtil.isTalismanEnabled(player2, charmName)) {
            return;
        }
        BlockPos currentPos = player2.blockPosition();
        BlockPos lastPos = lastPositions.getOrDefault(playerId, BlockPos.ZERO);
        long lastMoveTick = lastMovementTimes.getOrDefault(playerId, currentTick);
        if (lastPos == BlockPos.ZERO) {
            lastPositions.put(playerId, currentPos);
            lastMovementTimes.put(playerId, currentTick);
            return;
        }
        if (!currentPos.equals((Object)lastPos)) {
            lastPositions.put(playerId, currentPos);
            lastMovementTimes.put(playerId, currentTick);
            ShinyStoneItem.removeShinyStoneEffect((Player)player2);
            return;
        }
        long ticksStill = currentTick - lastMoveTick;
        if (ticksStill >= 600L) {
            ShinyStoneItem.applyShinyStoneEffect((Player)player2);
        } else {
            ShinyStoneItem.removeShinyStoneEffect((Player)player2);
        }
    }

    private static void applyShinyStoneEffect(Player player) {
        boolean needsRefresh;
        MobEffectInstance currentEffect = player.getEffect(MobEffects.REGENERATION);
        boolean bl = needsRefresh = currentEffect == null || currentEffect.getAmplifier() < 0 || currentEffect.getDuration() < 10;
        if (needsRefresh) {
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 40, 0, false, false));
            shinyStoneActivePlayers.add(player.getUUID());
        }
    }

    private static void removeShinyStoneEffect(Player player) {
        if (shinyStoneActivePlayers.contains(player.getUUID())) {
            MobEffectInstance currentEffect = player.getEffect(MobEffects.REGENERATION);
            if (currentEffect != null) {
                player.removeEffect(MobEffects.REGENERATION);
            }
            shinyStoneActivePlayers.remove(player.getUUID());
        }
    }
}

