/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.scavenged;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Reindeer_Bells_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ReindeerBellsItem
extends TalismanItem
implements ICurioItem,
Reindeer_Bells_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    public static final String charmName = "reindeer_bells";
    private static final ResourceLocation JUMP_BOOST_ID = ResourceLocation.fromNamespaceAndPath((String)"fargos", (String)"reindeer_bells_jump_boost");
    private static final AttributeModifier JUMP_BOOST_MODIFIER = new AttributeModifier(JUMP_BOOST_ID, 0.3, AttributeModifier.Operation.ADD_VALUE);

    public ReindeerBellsItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.reindeer_bells").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!ReindeerBellsItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            return (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Error checking config status for reindeer_bells");
            return true;
        }
    }

    private static void applyJumpBoost(Player player) {
        AttributeInstance jump = player.getAttribute(Attributes.JUMP_STRENGTH);
        if (jump != null && jump.getModifier(JUMP_BOOST_ID) == null) {
            jump.addTransientModifier(JUMP_BOOST_MODIFIER);
        }
    }

    private static void removeJumpBoost(Player player) {
        AttributeInstance jump = player.getAttribute(Attributes.JUMP_STRENGTH);
        if (jump != null && jump.getModifier(JUMP_BOOST_ID) != null) {
            jump.removeModifier(JUMP_BOOST_MODIFIER);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        if (!player.level().isClientSide) {
            ReindeerBellsItem.removeJumpBoost(player);
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            boolean hasModifier;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            boolean equipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Reindeer_Bells_Provider, (LivingEntity)player2).isPresent();
            boolean enabled = TalismanUtil.isTalismanEnabled(player2, ReindeerBellsItem.charmName);
            AttributeInstance jump = player2.getAttribute(Attributes.JUMP_STRENGTH);
            boolean bl = hasModifier = jump != null && jump.getModifier(JUMP_BOOST_ID) != null;
            if (!equipped || !enabled) {
                if (hasModifier) {
                    ReindeerBellsItem.removeJumpBoost((Player)player2);
                }
            } else if (!hasModifier) {
                ReindeerBellsItem.applyJumpBoost((Player)player2);
            }
        }
    }
}

