/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Redstone_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Redstone_Talisman
extends TalismanItem
implements Redstone_Talisman_Provider {
    private static final String talismanName = "redstone_talisman";
    private static final Map<UUID, PlayerRepairData> repairDataMap = new HashMap<UUID, PlayerRepairData>();
    private static final Random random = new Random();

    public Redstone_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.redstone_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        boolean isEnabled = TalismanUtil.checkConfigEnabledStatus(talismanName);
        if (!isEnabled) {
            tooltipComponents.add((Component)Component.literal((String)"(Disabled in Server Config)").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private static void repairArmorOverTime(Player player, long currentTime) {
        long baseInterval;
        UUID playerId = player.getUUID();
        PlayerRepairData repairData = repairDataMap.get(playerId);
        if (repairData == null) {
            baseInterval = ((Integer)Config.REDSTONE_TALISMAN_ARMOR_REPAIR_DURATION.get()).intValue();
            long nextRepairInterval = baseInterval + (long)random.nextInt(2500);
            repairData = new PlayerRepairData(0L, nextRepairInterval);
            repairDataMap.put(playerId, repairData);
        }
        if (currentTime - repairData.lastRepairTime > repairData.nextRepairInterval) {
            player.getInventory().armor.forEach(Redstone_Talisman::repairSingleArmorItem);
            repairData.lastRepairTime = currentTime;
            baseInterval = ((Integer)Config.REDSTONE_TALISMAN_ARMOR_REPAIR_DURATION.get()).intValue();
            repairData.nextRepairInterval = baseInterval + (long)random.nextInt(2500);
        }
    }

    private static void repairSingleArmorItem(ItemStack armorItem) {
        if (armorItem.isDamaged()) {
            armorItem.setDamageValue(armorItem.getDamageValue() - 1);
        }
    }

    private static class PlayerRepairData {
        long lastRepairTime;
        long nextRepairInterval;

        PlayerRepairData(long lastRepairTime, long nextRepairInterval) {
            this.lastRepairTime = lastRepairTime;
            this.nextRepairInterval = nextRepairInterval;
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            ServerPlayer player;
            Player player2 = event.getEntity();
            if (player2 instanceof ServerPlayer && ((player = (ServerPlayer)player2).hasEffect(EffectsInit.REDSTONE_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Redstone_Talisman_Provider, (LivingEntity)player).isPresent())) {
                if (!TalismanUtil.isTalismanEnabled(player, Redstone_Talisman.talismanName)) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                Redstone_Talisman.repairArmorOverTime((Player)player, currentTime);
            }
        }
    }
}

