/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Undying_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Undying_Talisman
extends TalismanItem
implements Undying_Talisman_Provider {
    private static final String talismanName = "undying_talisman";
    private static final Map<UUID, Long> cooldownMap = new HashMap<UUID, Long>();

    public Undying_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.undying_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Undying_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            return (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean isEligible(ServerPlayer player) {
        if (!TalismanUtil.isTalismanEnabled(player, talismanName)) {
            return false;
        }
        return player.hasEffect(EffectsInit.UNDYING_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Undying_Talisman_Provider, (LivingEntity)player).isPresent();
    }

    private static boolean isOnCooldown(ServerPlayer player, long currentTime) {
        return currentTime - cooldownMap.getOrDefault(player.getUUID(), 0L) < (long)Config.UNDYING_TALISMAN_COOLDOWN.getAsInt();
    }

    private static void revivePlayer(ServerPlayer player, long currentTime) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.setHealth(player.getMaxHealth());
        cooldownMap.put(player.getUUID(), currentTime);
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingIncomingDamageEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!Undying_Talisman.isEligible(player)) {
                return;
            }
            float healthAfter = player.getHealth() - event.getAmount();
            if (healthAfter > 0.0f) {
                return;
            }
            long now = player.level().getGameTime();
            if (!Undying_Talisman.isOnCooldown(player, now)) {
                Undying_Talisman.revivePlayer(player, now);
                event.setCanceled(true);
            }
        }
    }
}

