/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.recipe.ModRecipes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class JeiMarketRecipeCategory
implements IRecipeCategory<RecipeHolder<MarketRecipe>> {
    public static final RecipeType<RecipeHolder<MarketRecipe>> TYPE = RecipeType.createFromVanilla(ModRecipes.marketRecipeType);
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"farmingforblockheads", (String)"textures/gui/jei_market.png");
    private final IDrawable icon;
    private final IDrawableStatic background;

    public JeiMarketRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.market));
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 86, 48);
    }

    public RecipeType<RecipeHolder<MarketRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.farmingforblockheads.market");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<MarketRecipe> recipeHolder, IFocusGroup focuses) {
        MarketRecipe recipe = (MarketRecipe)recipeHolder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 13).addIngredients(recipe.getPaymentOrDefault().ingredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 54, 13).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    public void draw(RecipeHolder<MarketRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Component costText = this.getFormattedCostString((MarketRecipe)recipeHolder.value());
        Font font = Minecraft.getInstance().font;
        int stringWidth = font.width((FormattedText)costText);
        guiGraphics.drawString(font, costText.getVisualOrderText(), 42 - stringWidth / 2, 35, 0xFFFFFF, true);
    }

    private Component getFormattedCostString(MarketRecipe recipe) {
        Payment payment = recipe.getPaymentOrDefault();
        return payment.tooltip().orElseGet(() -> FarmingForBlockheads.getDefaultPaymentComponent(payment));
    }
}

