/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.flourish.mixin;

import com.diontryban.flourish.Flourish;
import com.diontryban.flourish.options.FlourishOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={FlowerBlock.class})
public abstract class FlowerBlockMixin
extends BushBlock
implements BonemealableBlock {
    protected FlowerBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return !(!state.is(BlockTags.SMALL_FLOWERS) || !((FlourishOptions)Flourish.OPTIONS.get()).witherRose && state.getBlock() == Blocks.WITHER_ROSE || !((FlourishOptions)Flourish.OPTIONS.get()).torchflower && state.getBlock() == Blocks.TORCHFLOWER);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (((FlourishOptions)Flourish.OPTIONS.get()).useTallFlowerBehavior) {
            this.flourish$tallFlowerBehavior(level, pos);
        } else {
            this.flourish$bedrockEditionBehavior(level, random, pos);
        }
    }

    @Unique
    private void flourish$tallFlowerBehavior(ServerLevel level, BlockPos pos) {
        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this, 1));
    }

    @Unique
    private void flourish$bedrockEditionBehavior(ServerLevel level, RandomSource random, BlockPos pos) {
        int maxSuccesses = random.nextIntBetweenInclusive(1, 7);
        int successCounter = 0;
        for (int i = 0; i < 64 && successCounter < maxSuccesses; ++i) {
            BlockPos newPos = pos;
            for (int j = 0; j < i / 22 + 1; ++j) {
                newPos = newPos.offset(random.nextIntBetweenInclusive(-1, 1), 0, random.nextIntBetweenInclusive(-1, 1));
            }
            BlockPos below = (newPos = newPos.offset(0, random.nextIntBetweenInclusive(-1, 1), 0)).below();
            if (!this.mayPlaceOn(level.getBlockState(below), (BlockGetter)level, below) || !level.getBlockState(newPos).isAir()) continue;
            level.setBlock(newPos, this.defaultBlockState(), 3);
            FlowerBlockMixin.flourish$addGrowthParticles(level, newPos, random.nextInt(14));
            ++successCounter;
        }
    }

    @Unique
    private static void flourish$addGrowthParticles(ServerLevel pLevel, BlockPos pPos, int pData) {
        double d1;
        if (pData == 0) {
            pData = 15;
        }
        BlockState blockstate = pLevel.getBlockState(pPos);
        double d0 = 0.5;
        if (blockstate.is(Blocks.WATER)) {
            pData *= 3;
            d1 = 1.0;
            d0 = 3.0;
        } else if (blockstate.isSolidRender((BlockGetter)pLevel, pPos)) {
            pPos = pPos.above();
            pData *= 3;
            d0 = 3.0;
            d1 = 1.0;
        } else {
            d1 = blockstate.getShape((BlockGetter)pLevel, pPos).max(Direction.Axis.Y);
        }
        pLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        RandomSource randomsource = pLevel.getRandom();
        for (int i = 0; i < pData; ++i) {
            double d8;
            double d7;
            double d2 = randomsource.nextGaussian() * 0.02;
            double d3 = randomsource.nextGaussian() * 0.02;
            double d4 = randomsource.nextGaussian() * 0.02;
            double d9 = randomsource.nextGaussian() * 0.02;
            double d5 = 0.5 - d0;
            double d6 = (double)pPos.getX() + d5 + randomsource.nextDouble() * d0 * 2.0;
            if (pLevel.getBlockState(BlockPos.containing((double)d6, (double)(d7 = (double)pPos.getY() + randomsource.nextDouble() * d1), (double)(d8 = (double)pPos.getZ() + d5 + randomsource.nextDouble() * d0 * 2.0)).below()).isAir()) continue;
            pLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, d6, d7, d8, 1, d2, d3, d4, d9);
        }
    }
}

