/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.mojang.serialization.MapCodec;
import com.stal111.forbidden_arcanus.common.block.ForbiddenomiconBlock;
import com.stal111.forbidden_arcanus.common.block.ResearchDeskBlock;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import org.jetbrains.annotations.Nullable;

public class DeskBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<DeskBlock> CODEC = DeskBlock.simpleCodec(DeskBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape INSIDE_SHAPE = Block.box((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)9.0, (double)12.0);
    private static final VoxelShape BOTTOM_SHAPE = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), (VoxelShape)INSIDE_SHAPE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape TOP_SHAPE = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TOP_SHAPE);
    private final Map<BlockState, VoxelShape> shapesCache;

    public DeskBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.getShapeForEachState(DeskBlock::calculateShape);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    private static VoxelShape calculateShape(BlockState state) {
        return VoxelShapeHelper.rotateShapeHorizontal((VoxelShape)SHAPE, (Direction)((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (stack.is(((ForbiddenomiconBlock)((Object)ModBlocks.FORBIDDENOMICON.get())).asItem())) {
            BlockState newState = (BlockState)((BlockState)((ResearchDeskBlock)((Object)ModBlocks.RESEARCH_DESK.get())).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
            level.setBlockAndUpdate(pos, newState);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        return false;
    }
}

