/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.essence;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public enum EssenceType implements StringRepresentable
{
    AUREAL("aureal", 7, (Holder<ParticleType<?>>)ModParticles.AUREAL_DROP),
    SOULS("souls", 0, (Holder<ParticleType<?>>)ModParticles.SOULS_DROP),
    BLOOD("blood", 0, (Holder<ParticleType<?>>)ModParticles.BLOOD_DROP),
    EXPERIENCE("experience", 13, (Holder<ParticleType<?>>)ModParticles.EXPERIENCE_DROP);

    public static final StringRepresentable.EnumCodec<EssenceType> CODEC;
    public static final StreamCodec<FriendlyByteBuf, EssenceType> STREAM_CODEC;
    private final String name;
    private final int lightEmission;
    private final Holder<ParticleType<?>> particleType;
    private final Component component;
    private final ResourceLocation spriteLocation;

    private EssenceType(String name, int lightEmission, Holder<ParticleType<?>> particleType) {
        this.name = name;
        this.lightEmission = lightEmission;
        this.particleType = particleType;
        this.component = Component.translatable((String)Util.makeDescriptionId((String)"essence", (ResourceLocation)ForbiddenArcanus.location(name)));
        this.spriteLocation = ForbiddenArcanus.location("icon/" + name);
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getLightEmission() {
        return this.lightEmission;
    }

    public ParticleType<?> getParticleType() {
        return (ParticleType)this.particleType.value();
    }

    public ResourceLocation getSpriteLocation() {
        return this.spriteLocation;
    }

    static {
        CODEC = StringRepresentable.fromEnum(EssenceType::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(EssenceType.class);
    }
}

