/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.mojang.blaze3d.vertex.PoseStack;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.client.FARenderTypes;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.valhelsia.valhelsia_core.api.common.counter.SimpleCounter;

public class ValidRitualIndicator {
    private static final ResourceLocation INDICATOR = ForbiddenArcanus.location("textures/effect/magic_circle/valid_ritual_indicator.png");
    private static final int ANIMATION_DURATION = 60;
    private final IndicatorCounter counter = new IndicatorCounter();

    public ValidRitualIndicator(boolean playAnimation) {
        this.counter.setActive(playAnimation);
    }

    public static float easeOutBack(float progress, float start, float change, float duration) {
        float s = 1.70158f;
        progress = progress / duration - 1.0f;
        return change * (progress * progress * ((s + 1.0f) * progress + s) + 1.0f) + start;
    }

    public void tick() {
        this.counter.tick();
    }

    public void render(PoseStack poseStack, float partialTicks, MultiBufferSource buffer, int packedLight, ModelPart model) {
        poseStack.pushPose();
        poseStack.translate(0.5, 2.0E-4, 0.5);
        poseStack.scale(8.5f, 1.0f, 8.5f);
        model.render(poseStack, buffer.getBuffer(FARenderTypes.entityFullbrightTranslucent(INDICATOR)), packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)Math.min(1.0f, ValidRitualIndicator.easeOutBack(this.counter.getValue().intValue(), 0.0f, 1.0f, 60.0f)), (float)1.0f, (float)1.0f, (float)1.0f));
        poseStack.popPose();
    }

    private static class IndicatorCounter
    extends SimpleCounter {
        private IndicatorCounter() {
        }

        public void tick(CompoundTag tag) {
            if (this.isActive()) {
                if (this.value >= 60) {
                    this.setActive(false);
                    return;
                }
                this.increase();
            }
        }
    }
}

