/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity;

import com.stal111.forbidden_arcanus.common.entity.CustomBoat;
import com.stal111.forbidden_arcanus.common.entity.ModBoat;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ModChestBoat
extends ChestBoat
implements CustomBoat {
    private static final EntityDataAccessor<Integer> DATA_ID_WOOD_TYPE = SynchedEntityData.defineId(ModChestBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModChestBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    public ModChestBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)ModEntities.CHEST_BOAT.get()), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_WOOD_TYPE, (Object)0);
    }

    protected void readAdditionalSaveData(@Nonnull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Type", 8)) {
            this.setWoodType(ModBoat.Type.byName(tag.getString("Type")));
        }
    }

    protected void addAdditionalSaveData(@Nonnull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("Type", this.getWoodType().getSerializedName());
    }

    @Nonnull
    public Item getDropItem() {
        return (Item)this.getWoodType().getChestBoatItem().get();
    }

    @Override
    public ModBoat.Type getWoodType() {
        return ModBoat.Type.byId((Integer)this.entityData.get(DATA_ID_WOOD_TYPE));
    }

    @Override
    public void setWoodType(ModBoat.Type type) {
        this.entityData.set(DATA_ID_WOOD_TYPE, (Object)type.ordinal());
    }

    @Nonnull
    protected Component getTypeName() {
        return EntityType.CHEST_BOAT.getDescription();
    }
}

