/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.projectile;

import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class EnergyBall
extends Projectile {
    private static final float MOTION_FACTOR = 0.95f;
    private static final float MOTION_FACTOR_WATER = 0.8f;
    private static final float ROTATION_SPEED = 0.2f;
    private static final float DAMAGE_AMOUNT = 5.5f;
    private LivingEntity shootingEntity;
    private int ticksAlive;
    private double accelerationX;
    private double accelerationY;
    private double accelerationZ;

    public EnergyBall(Level level, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntities.ENERGY_BALL.get(), level);
        this.shootingEntity = shooter;
        this.moveTo(shooter.getX(), shooter.getY(), shooter.getZ(), shooter.yRotO, shooter.xRotO);
        this.setPos(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(Vec3.ZERO);
        double d0 = Mth.sqrt((float)((float)(accelX * accelX + accelY * accelY + accelZ * accelZ)));
        this.accelerationX = accelX / d0 * 0.1;
        this.accelerationY = accelY / d0 * 0.1;
        this.accelerationZ = accelZ / d0 * 0.1;
    }

    public EnergyBall(EntityType<? extends EnergyBall> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void tick() {
        super.tick();
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, entity -> entity.isAlive() && entity != this.shootingEntity);
        if (hitResult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.onImpact(hitResult);
        }
        Vec3 vec3 = this.getDeltaMovement();
        this.setPos(this.getX() + vec3.x, this.getY() + (vec3.y - 0.01), this.getZ() + vec3.z);
        ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
        float motionFactor = 0.95f;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vec3.x * 0.25, this.getY() - vec3.y * 0.25, this.getZ() - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
            motionFactor = 0.8f;
        }
        this.setDeltaMovement(vec3.add(this.accelerationX, this.accelerationY, this.accelerationZ).scale((double)motionFactor));
        this.setPos(this.getX(), this.getY(), this.getZ());
    }

    public void onImpact(HitResult result) {
        if (this.level().isClientSide()) {
            return;
        }
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            Entity entity = entityHitResult.getEntity();
            entity.hurt(this.level().damageSources().indirectMagic((Entity)this, (Entity)this.shootingEntity), 5.5f);
            LightningBolt lightningBolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
            lightningBolt.setPos(entity.getX(), entity.getY(), entity.getZ());
            this.level().addFreshEntity((Entity)lightningBolt);
        } else if (result.getType() == HitResult.Type.BLOCK) {
            Vec3 vec3 = result.getLocation();
            this.level().playSound(null, vec3.x(), vec3.y(), vec3.z(), (SoundEvent)ModSounds.ENERGY_BALL_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        this.discard();
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        Vec3 vec3 = this.getDeltaMovement();
        tag.put("direction", (Tag)this.newDoubleList(new double[]{vec3.x, vec3.y, vec3.z}));
        tag.put("power", (Tag)this.newDoubleList(new double[]{this.accelerationX, this.accelerationY, this.accelerationZ}));
        tag.putInt("life", this.ticksAlive);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        ListTag list;
        if (tag.contains("power", 9) && (list = tag.getList("power", 6)).size() == 3) {
            this.accelerationX = list.getDouble(0);
            this.accelerationY = list.getDouble(1);
            this.accelerationZ = list.getDouble(2);
        }
        this.ticksAlive = tag.getInt("life");
        if (tag.contains("direction", 9) && tag.getList("direction", 6).size() == 3) {
            list = tag.getList("direction", 6);
            this.setDeltaMovement(list.getDouble(0), list.getDouble(1), list.getDouble(2));
        } else {
            this.discard();
        }
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean hurt(@Nonnull DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markHurt();
        if (source.getEntity() != null) {
            Vec3 vec3 = source.getEntity().getLookAngle();
            this.setDeltaMovement(vec3);
            this.accelerationX = vec3.x * 0.1;
            this.accelerationY = vec3.y * 0.1;
            this.accelerationZ = vec3.z * 0.1;
            Entity entity = source.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.shootingEntity = livingEntity = (LivingEntity)entity;
            }
            return true;
        }
        return false;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }
}

