/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.item.modifier.ModifierHelper;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public record ItemModifier(ItemPredicate predicate, HolderSet<Item> incompatibleItems, HolderSet<Enchantment> incompatibleEnchantments, HolderSet<DataComponentType<?>> componentsToRemove, DisplaySettings displaySettings) {
    public static final Codec<ItemModifier> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemPredicate.CODEC.fieldOf("predicate").forGetter(ItemModifier::predicate), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).optionalFieldOf("incompatible_items", (Object)HolderSet.empty()).forGetter(ItemModifier::incompatibleItems), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).optionalFieldOf("incompatible_enchantments", (Object)HolderSet.empty()).forGetter(ItemModifier::incompatibleEnchantments), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.DATA_COMPONENT_TYPE).optionalFieldOf("components_to_remove", (Object)HolderSet.empty()).forGetter(ItemModifier::componentsToRemove), (App)DisplaySettings.CODEC.fieldOf("display").forGetter(modifier -> modifier.displaySettings)).apply((Applicative)instance, ItemModifier::new));
    public static final Codec<Holder<ItemModifier>> CODEC = RegistryFileCodec.create(FARegistries.ITEM_MODIFIER, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<ItemModifier>> STREAM_CODEC = ByteBufCodecs.holderRegistry(FARegistries.ITEM_MODIFIER);

    public void onApplied(ItemStack stack) {
        if (!stack.has(DataComponents.CUSTOM_NAME)) {
            stack.update(DataComponents.ITEM_NAME, (Object)stack.getItem().getName(stack), component -> this.displaySettings.name.copy().append(" ").append(component));
        }
        for (Holder component2 : this.componentsToRemove) {
            stack.remove((DataComponentType)component2.value());
        }
    }

    public boolean isValidItem(ItemStack stack) {
        if (stack.is(this.incompatibleItems) || !this.predicate.test(stack) || ModifierHelper.hasModifier(stack)) {
            return false;
        }
        Set enchantments = stack.getTagEnchantments().keySet();
        return this.incompatibleEnchantments.stream().noneMatch(enchantments::contains);
    }

    public record DisplaySettings(Component name, ResourceLocation texture, Pair<Integer, Integer> tooltipColor) {
        public static final Codec<DisplaySettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("name").forGetter(DisplaySettings::name), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(DisplaySettings::texture), (App)Codec.pair((Codec)Codec.INT.fieldOf("start").codec(), (Codec)Codec.INT.fieldOf("end").codec()).fieldOf("tooltip_color").forGetter(DisplaySettings::tooltipColor)).apply((Applicative)instance, DisplaySettings::new));
    }
}

