/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.server.loot;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class ModChestLootAdditions
implements LootTableSubProvider {
    public static final ResourceKey<LootTable> ARTISAN_RELIC_ADDITION = ModChestLootAdditions.register("chests/additions/artisan_relic_addition");
    public static final ResourceKey<LootTable> CRIMSON_STONE_ADDITION = ModChestLootAdditions.register("chests/additions/crimson_stone_addition");
    public static final ResourceKey<LootTable> ELEMENTARIUM_ADDITION = ModChestLootAdditions.register("chests/additions/elementarium_addition");
    public static final ResourceKey<LootTable> MALEDICTUS_PACT_ADDITION = ModChestLootAdditions.register("chests/additions/maledictus_pact_addition");
    public static final ResourceKey<LootTable> DRAGON_SCALE_ADDITION = ModChestLootAdditions.register("chests/additions/dragon_scale_addition");
    public static final ResourceKey<LootTable> AUREAL_BOTTLE_ADDITION = ModChestLootAdditions.register("chests/additions/aureal_bottle_addition");
    private final HolderLookup.Provider lookupProvider;

    public ModChestLootAdditions(HolderLookup.Provider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        consumer.accept(ARTISAN_RELIC_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.ARTISAN_RELIC)).when(LootItemRandomChanceCondition.randomChance((float)0.28f))));
        consumer.accept(CRIMSON_STONE_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.CRIMSON_STONE)).when(LootItemRandomChanceCondition.randomChance((float)0.18f))));
        consumer.accept(ELEMENTARIUM_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.ELEMENTARIUM)).when(LootItemRandomChanceCondition.randomChance((float)0.21f))));
        consumer.accept(MALEDICTUS_PACT_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.MALEDICTUS_PACT)).when(LootItemRandomChanceCondition.randomChance((float)0.18f))));
        consumer.accept(DRAGON_SCALE_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.DRAGON_SCALE)).when(LootItemRandomChanceCondition.randomChance((float)0.56f)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))));
        consumer.accept(AUREAL_BOTTLE_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.AUREAL_BOTTLE)).when(LootItemRandomChanceCondition.randomChance((float)0.2f)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))));
    }

    private static ResourceKey<LootTable> register(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ForbiddenArcanus.location(name));
    }
}

