/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.archival;

import dev.ftb.mods.ftbbackups.FTBBackups;
import dev.ftb.mods.ftbbackups.api.IArchivalPlugin;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;

public enum FileCopyArchiver implements IArchivalPlugin
{
    INSTANCE;

    public static final ResourceLocation ID;

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public String getFileExtension() {
        return "";
    }

    @Override
    public long createArchive(IArchivalPlugin.ArchivalContext context) {
        long archiveSize = 0L;
        for (Map.Entry<Path, String> entry : context.manifest().entrySet()) {
            try {
                Path file = entry.getKey();
                context.notifyProcessingFile(entry.getValue());
                Path newFile = context.archivePath().resolve(Path.of(entry.getValue(), new String[0]));
                Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
                Files.copy(file, newFile, StandardCopyOption.COPY_ATTRIBUTES);
                archiveSize += Files.size(newFile);
            }
            catch (Exception ex) {
                context.logger().error("Failed to copy file {}: {}", (Object)entry.getValue(), (Object)ex);
            }
        }
        return archiveSize;
    }

    @Override
    public void restoreArchive(IArchivalPlugin.RestorationContext context) throws Exception {
        Path srcDir = context.archivePath();
        try (Stream<Path> s = Files.walk(srcDir, new FileVisitOption[0]);){
            s.forEach(source -> {
                if (Files.isRegularFile(source, new LinkOption[0])) {
                    Path destination = context.destinationFolder().resolve(srcDir.relativize((Path)source));
                    try {
                        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                        context.notifyProcessingFile(source.toString());
                        Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (Exception ex) {
                        context.logger().error("Failed to copy {} -> {}: {}", new Object[]{source, destination, ex});
                    }
                }
            });
        }
    }

    static {
        ID = FTBBackups.id("filecopy");
    }
}

