/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.archival;

import dev.ftb.mods.ftbbackups.FTBBackups;
import dev.ftb.mods.ftbbackups.api.IArchivalPlugin;
import dev.ftb.mods.ftbbackups.config.FTBBackupsServerConfig;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.resources.ResourceLocation;

public enum ZipArchiver implements IArchivalPlugin
{
    INSTANCE;

    public static final ResourceLocation ID;

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public long createArchive(IArchivalPlugin.ArchivalContext context) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(context.archivePath().toFile()));
        zos.setLevel(context.compressionLevel());
        byte[] buffer = new byte[((Integer)FTBBackupsServerConfig.BUFFER_SIZE.get()).intValue()];
        context.logger().info("Zipping {} files...", (Object)context.manifest().size());
        for (Map.Entry<Path, String> entry : context.manifest().entrySet()) {
            Path absPath = entry.getKey();
            String archiveEntry = entry.getValue();
            try {
                int len;
                context.notifyProcessingFile(archiveEntry);
                ZipEntry ze = new ZipEntry(archiveEntry);
                zos.putNextEntry(ze);
                FileInputStream fis = new FileInputStream(absPath.toFile());
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
                fis.close();
            }
            catch (IOException ex) {
                context.logger().error("Couldn't add {} to ZIP archive: {}", (Object)archiveEntry, (Object)ex);
            }
        }
        zos.close();
        return Files.size(context.archivePath());
    }

    @Override
    public void restoreArchive(IArchivalPlugin.RestorationContext context) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(context.archivePath().toFile()));
        byte[] buffer = new byte[((Integer)FTBBackupsServerConfig.BUFFER_SIZE.get()).intValue()];
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            context.notifyProcessingFile(zipEntry.getName());
            if (zipEntry.isDirectory()) {
                context.logger().warn("ignoring directory entry {}", (Object)zipEntry.getName());
                continue;
            }
            Path destFile = ZipArchiver.safePath(context.destinationFolder(), zipEntry);
            Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
            context.logger().info("extract to {}", (Object)destFile);
            try (FileOutputStream fos = new FileOutputStream(destFile.toFile());){
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private static Path safePath(Path destDir, ZipEntry zipEntry) throws IOException {
        Path subPath = Path.of(zipEntry.getName(), new String[0]);
        if (subPath.isAbsolute()) {
            throw new IOException("absolute paths not allowed!");
        }
        return destDir.resolve(subPath);
    }

    static {
        ID = FTBBackups.id("zip");
    }
}

