/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.component.ResolvableProfile;

public record SendPlayerPositionPacket(ResolvableProfile profile, Optional<BlockPos> pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SendPlayerPositionPacket> TYPE = new CustomPacketPayload.Type(FTBChunksAPI.rl("send_player_position_packet"));
    public static final StreamCodec<FriendlyByteBuf, SendPlayerPositionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResolvableProfile.STREAM_CODEC, SendPlayerPositionPacket::profile, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), SendPlayerPositionPacket::pos, SendPlayerPositionPacket::new);

    public static SendPlayerPositionPacket startTracking(ServerPlayer player) {
        return new SendPlayerPositionPacket(new ResolvableProfile(player.getGameProfile()), Optional.of(player.blockPosition()));
    }

    public static SendPlayerPositionPacket stopTracking(ServerPlayer player) {
        return new SendPlayerPositionPacket(new ResolvableProfile(player.getGameProfile()), Optional.empty());
    }

    public CustomPacketPayload.Type<SendPlayerPositionPacket> type() {
        return TYPE;
    }

    public static void handle(SendPlayerPositionPacket message, NetworkManager.PacketContext context) {
        FTBChunksClient.INSTANCE.updateTrackedPlayerPos(message.profile.gameProfile(), message.pos.orElse(null));
    }
}

